% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod-file-summary.R
\name{file_summary_ui}
\alias{file_summary_ui}
\alias{file_summary_server}
\title{UI for the file summary module}
\usage{
file_summary_ui(id)

file_summary_server(input, output, session, file_data)
}
\arguments{
\item{id}{the id}

\item{input}{the input variables from \code{\link[shiny:callModule]{shiny::callModule()}}}

\item{output}{the output variables from \code{\link[shiny:callModule]{shiny::callModule()}}}

\item{session}{the session from \code{\link[shiny:callModule]{shiny::callModule()}}}

\item{file_data}{a reactive, named list of file data in data frames or
tibbles}
}
\value{
html UI for file summary


}
\description{
Creates the UI for the file summary module, complete with a
drop-down selection box, and two tabs, one for a file overview and one for
file details.

Gives functionality to the file summary UI, populating the
drop-down menu with available files to choose from, and showing both an
overview and detailed summary of a chosen file.
}
\examples{
library("shiny")
library("shinydashboard")

server <- function(input, output) {
  # Create some simple file dataa
  data <- reactive({
    list(
      "individual" = data.frame(
        individualID = c("a", "b", "c"),
        age = c(23, 24, 24),
        stringsAsFactors = FALSE
      ),
      "biospecimen" = data.frame(
        individualID = c("a", "b", "c"),
        specimenID = c("a1", "b1", "c1"),
        isReal = c(FALSE, FALSE, FALSE),
        stringsAsFactors = FALSE
      )
    )
  })
  # Show file summary
  callModule(file_summary_server, "summary", file_data = data)
}

ui <- function(request) {
  dashboardPage(
    header = dashboardHeader(),
    sidebar = dashboardSidebar(),
    body = dashboardBody(
      includeCSS(
        system.file("app/www/custom.css", package = "dccvalidator")
      ),
      file_summary_ui("summary")
    )
  )
}
\dontrun{
shinyApp(ui, server)
}
}
