\name{survivalSL}
\alias{survivalSL}

\title{
	Estimate SL survival function
}
\description{
This function estimates the \eqn{S_L}{SL} survival function from doubly censored data. 
It receives the processed data returned by \code{survProcessing} function and the 
estimation of the \eqn{S_T}{ST} survival function.
}

\usage{
survivalSL(procData, ST)
}

\arguments{
  \item{procData}{
		A list with the processed data returned by the \code{survProcessing} function.
}
  \item{ST}{
		A matrix with the estimation of the \eqn{S_T}{ST} survival function returned by the \code{survivalST} function.
}
}

\value{
A two-column matrix where the first column corresponds to the sorted different times and the second one 
corresponds to the estimated values for the \eqn{S_L}{SL} survival function.   
}
\author{
	O. Juli, G. Gmez, C. Serrat and J. Corts.
}



\seealso{
	\code{\link{survProcessing}}, \code{\link{survivalST}}
}

