% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dump_sql.R
\name{dump_sql}
\alias{dump_sql}
\title{Show generated sql}
\usage{
dump_sql(x, table, con = NULL, file = stdout(), ...)
}
\arguments{
\item{x}{\code{dcmodify::modifier()} object with rules to be written}

\item{table}{either a \code{\link[dplyr:tbl]{dplyr::tbl()}} object or a \code{character} with table name}

\item{con}{optional, when \code{table} is a character, a dbi connection.}

\item{file}{to which the sql will be written.}

\item{...}{not used}
}
\value{
\code{character} sql script with all statements.
}
\description{
Writes the generated sql to a file or command line. The script contains ALTER and
UPDATE statements and can be used for documentation purposes.
}
\details{
Note that when this script is run on the database it will change the
original table. This differs from the default behavior of dcmodify which
works on a (temporary) copy of the table.

Furthermore, it seems wise to wrap the generated SQL in a transaction when
apply the SQL code on a database.
}
\examples{
# load modification rules and apply:
library(dcmodify)

con <- DBI::dbConnect(RSQLite::SQLite(), dbname=system.file("db/person.db", package="dcmodifydb"))
person <- dplyr::tbl(con, "person")

rules <- modifier(.file = system.file("db/corrections.yml", package="dcmodifydb"))
print(rules)

# show sql code generated from the rules.
dump_sql(rules, person)
}
\seealso{
Other sql translation: 
\code{\link{modifier_to_sql}()}
}
\concept{sql translation}
