% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnpp_experiment-filled.R
\name{get_filled_drops}
\alias{get_filled_drops}
\title{Get filled droplets in PNPP experiment}
\usage{
get_filled_drops(plate, well_id, border)
}
\arguments{
\item{plate}{A ddPCR plate.}

\item{well_id}{Get border of filled droplets for this well.}

\item{border}{(Optional) The filled droplets border, as calculated by
\code{\link[ddpcr]{get_filled_drops}}. If missing, then
\code{\link[ddpcr]{get_filled_drops}} is called to calculate the border.}
}
\value{
Dataframe with all filled droplets in the given well.
}
\description{
In a PNPP experiment, the rain droplets are the non-empty drops that don't have a
high enough intensity in the positive dimension to be considered as filled
with high quality sample DNA. Only droplets considered as filled are
candidates for the \code{negative} and \code{positive} clusters.
\code{get_filled_drops} returns the droplets that are considered filled.
}
\examples{
file <- system.file("sample_data", "small", "analyzed_pnpp.rds", package = "ddpcr")
plate <- load_plate(file)
get_filled_drops(plate, "A05")
get_filled_drops(plate, "A05", get_filled_border(plate, "A05"))
}
\seealso{
\code{\link[ddpcr]{pnpp_experiment}}\cr
\code{\link[ddpcr]{positive_dim}}\cr
\code{\link[ddpcr]{get_filled_drops}}
}
\keyword{internal}
