% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate-attribs.R
\name{steps}
\alias{steps}
\title{Analysis steps of a ddPCR plate}
\usage{
steps(plate)
}
\arguments{
\item{plate}{a ddPCR plate.}
}
\value{
A named character vector, where every name is the human-readable
name of an analysis step, and every value is the name of the function
used to perform the step.
}
\description{
Every ddPCR plate type has an ordered set of steps that are run to analyze
the data. You can run all the steps with \code{\link[ddpcr]{analyze}} or
run the analysis step by step with \code{\link[ddpcr]{next_step}}. The order
of the steps in the list is the order in which they are run on the dataset.
}
\examples{
\dontrun{
dir <- sample_data_dir()
new_plate(dir) \%>\% steps
new_plate(dir, plate_types$fam_positive_pnpp) \%>\% steps
}
}
\seealso{
\code{\link[ddpcr]{analyze}}\cr
\code{\link[ddpcr]{next_step}}
}
