% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/horzBarChart.R
\name{horzBarChart}
\alias{horzBarChart}
\title{Create a horizontal bar chart}
\usage{
horzBarChart(
  data,
  label,
  value,
  fill = "crimson",
  sort = "none",
  paddingWidth = 0.1,
  stroke = NULL,
  strokeWidth = 1,
  bgcol = "#CAD0D3",
  valueTicks = NULL,
  valueFontSize = 10,
  labelFontSize = 10,
  valueTitle = NULL,
  valueTitleFontSize = 14,
  labelTitle = NULL,
  labelTitleFontSize = 14,
  font = "Verdana, Geneva, Tahoma, sans-serif",
  title = NULL,
  titleFontSize = 20,
  opacity = 1,
  axisCol = "black",
  width = NULL,
  height = NULL
)
}
\arguments{
\item{data}{The data frame containing the variables to consider.}

\item{label}{The categorical variable to consider. Will be plotted on the y-axis.}

\item{value}{The numeric variable to consider. Will be plotted on the x-axis.}

\item{fill}{The color of the bars. Defaults to 'crimson'.}

\item{sort}{Optional. Takes the following arguments:
'none', 'ascending' or 'descending', default to 'none'}

\item{paddingWidth}{The distance between each bar.
The value goes from 0 to 0.99 included. Defaults to 0.1.}

\item{stroke}{Optional. The color of the stroke of the bars.}

\item{strokeWidth}{The width of the stroke of the bars. Defaults to 1 when the 'stroke' parameter is used.}

\item{bgcol}{Optional. The color of the background, default to:
'#CAD0D3'}

\item{valueTicks}{Optional. the number of x-axis ticks to consider.}

\item{valueFontSize}{The font size of the x-axis values. Defaults to 10.}

\item{labelFontSize}{The font size of the y-axis labels. Defaults to 10.}

\item{valueTitle}{Optional. The title of the x-axis.}

\item{valueTitleFontSize}{The font size of the x-axis title if specified. Defaults to 14.}

\item{labelTitle}{Optional. The title of the y-axis.}

\item{labelTitleFontSize}{The font size of the y-axis title. Defaults to 14.}

\item{font}{The font family of the text. Defaults to "Verdana, Geneva, Tahoma, sans-serif"}

\item{title}{Optional. The title of the overall graphic.}

\item{titleFontSize}{The font size of the overall graphic's title when specified.}

\item{opacity}{The color opacity of the bars. Goes from 0 to 1. Defaults to 1.}

\item{axisCol}{the color of the x and y axis. It includes the ticks, the labels and titles.
Defaults to 'black'.}

\item{width}{Optional. The width of the SVG output.}

\item{height}{Optional. The height of the SVG output.}
}
\value{
A SVG horizontal bar chart.
}
\description{
Create a horizontal bar chart
}
\examples{
library(ggplot2) # needed for the mpg data frame
library(dplyr) # needed for the data wrangling process

mpg \%>\% group_by(manufacturer) \%>\%
 summarise(median_hwy = median(hwy)) \%>\%
 horzBarChart(
   label = "manufacturer",
   value = "median_hwy",
   sort = "ascending"
 )
}
