% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stackedAreaChart.R
\name{stackedAreaChart}
\alias{stackedAreaChart}
\title{Create a stacked area chart}
\usage{
stackedAreaChart(
  data,
  x,
  colorCategory = "Category10",
  curve = "curveLinear",
  stroke = NULL,
  strokeWidth = 1.5,
  xticks = NULL,
  yticks = NULL,
  xtitle = NULL,
  xtitleFontSize = 16,
  ytitle = NULL,
  ytitleFontSize = 16,
  title = NULL,
  titleFontSize = 22,
  font = "Verdana, Geneva, Tahoma, sans-serif",
  bgcol = "#CAD0D3",
  opacity = 1,
  axisCol = "black",
  legendBoxSize = 18,
  legendTextSize = 18,
  width = NULL,
  height = NULL
)
}
\arguments{
\item{data}{The data frame containing the variables to consider.}

\item{x}{The x-variable to consider. Must be a date variable in 'yyyy-mm-dd' format.}

\item{colorCategory}{A D3 categorical color scheme, you can find more
here <https://github.com/d3/d3-scale-chromatic#categorical>. Defaults to 'Category10'.}

\item{curve}{The line's curve type to render.
A complete list can be found here <https://github.com/d3/d3-shape#curves>.
Defaults to 'curveLinear'.}

\item{stroke}{Optional. The color of the stroke of the area.}

\item{strokeWidth}{The width of the line. Defaults to 1.5.}

\item{xticks}{Optional. the number of x-axis ticks to consider.}

\item{yticks}{Optional. The number of y-axis ticks to consider.}

\item{xtitle}{Optional. The title of the x-axis.}

\item{xtitleFontSize}{The font size of the x-axis title. Defaults to 16.}

\item{ytitle}{Optional. The title of the y-axis.}

\item{ytitleFontSize}{The font size of the y-axis title. Defaults to 16.}

\item{title}{Optional. The title of the plot.}

\item{titleFontSize}{The font size of the plot title. Defaults to 22.}

\item{font}{The font family to consider for the titles. Defaults to
"Verdana, Geneva, Tahoma, sans-serif".}

\item{bgcol}{The background color of the SVG. Defaults to "#CAD0D3" HEX color.}

\item{opacity}{The color opacity of the area chart (from 0 to 1). Defaults to 1.}

\item{axisCol}{the color of the x and y axis. It includes the ticks, the labels and titles.
Defaults to 'black'.}

\item{legendBoxSize}{The size of the legend rectangles. Defaults to 18.}

\item{legendTextSize}{The font size of the legend text Defaults to 18.}

\item{width}{Optional. The width of the SVG output.}

\item{height}{Optional. The height of the SVG output.}
}
\value{
a SVG stacked area chart
}
\description{
Create a stacked area chart
}
\examples{
data <- data.frame(
  date = c(
    "2000-01-01", "2000-02-01", "2000-03-01", "2000-04-01",
    "2000-05-01", "2000-06-01", "2000-07-01",
    "2000-08-01", "2000-09-01", "2000-10-01"
  ),
  Trade = c(
    2000,1023, 983, 2793, 1821, 1837, 1792, 1853, 791, 739
  ),
  Manufacturing = c(
    734, 694, 739, 736, 685, 621, 708, 685, 667, 693
  ),
  Leisure = c(
    1782, 1779, 1789, 658, 675, 833, 786, 675, 636, 691
  ),
  Agriculture = c(
    655, 587,623, 517, 561, 2545, 636, 584, 559, 2504
  )
)

stackedAreaChart(
  data = data,
  x = "date",
  legendTextSize = 14,
  curve = "curveCardinal",
  colorCategory = "Accent",
  bgcol = "white",
  stroke = "black",
  strokeWidth = 1
)

}
