% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglikehoods.R
\name{logllk_ddt}
\alias{logllk_ddt}
\title{Calculate loglikelihood of a DDT, including the tree structure and node parameters}
\usage{
logllk_ddt(
  c,
  c_order,
  Sigma_by_group,
  tree_phylo4d,
  item_membership_list,
  tree_structure_old = NULL,
  dist_mat_old = NULL
)
}
\arguments{
\item{c}{a positive number for the divergence hyperparameter. A larger value implies
earlier divergence on the tree}

\item{c_order}{equals 1 if using divergence function a(t) = c / (1-t), or 2 if
a(t) = c / (1-t)^2. Default is 1}

\item{Sigma_by_group}{a vector of diffusion variances of G groups from the previous iteration}

\item{tree_phylo4d}{a "phylo4d" object}

\item{item_membership_list}{a list of G elements, where the g-th element contains the column
indices of \code{data} corresponding to items in major group g}

\item{tree_structure_old}{a list of at least named elements: loglikelihoods of the input tree topology
and divergence times. These can be directly obtained from the return of this function.
Default is NULL. If given a list, then computation of the loglikelihoods will be skipped to save time.
This is useful in the Metropolis-Hasting algorithm when the previous proposal is not accepted.}

\item{dist_mat_old}{a tree-structured covariance matrix from a given tree. Default is NULL.}
}
\value{
a numeric of loglikelihood
}
\description{
Calculate loglikelihood of a DDT, including the tree structure and node parameters
}
\seealso{
Other likelihood functions: 
\code{\link{logllk_ddt_lcm}()},
\code{\link{logllk_div_time_one}()},
\code{\link{logllk_div_time_two}()},
\code{\link{logllk_lcm}()},
\code{\link{logllk_location}()},
\code{\link{logllk_tree_topology}()}
}
\concept{likelihood functions}
