% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ode.R
\name{getODEGradient}
\alias{getODEGradient}
\title{Calculate gradients from ODE system}
\usage{
getODEGradient(X, timePoints, params, auxVars, species = 1:dim(X)[2])
}
\arguments{
\item{X}{Latent values for the species}

\item{timePoints}{Times at which to calculate the ODE gradients}

\item{params}{Current parameter estimates}

\item{auxVars}{Auxiliary variables (including function for ODE gradients)}

\item{species}{Which species to return (default=all)}
}
\value{
A T by \code{length(species)} matrix with the gradients calculated at each time point for the specified species.
}
\description{
Calculate gradients from ODE system
}
