% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiencies.dea_fuzzy.R
\name{efficiencies.dea_fuzzy}
\alias{efficiencies.dea_fuzzy}
\title{Efficiencies}
\usage{
\method{efficiencies}{dea_fuzzy}(x, ...)
}
\arguments{
\item{x}{Object of class dea or dea_fuzzy obtained with some of the dea model functions.}

\item{...}{Other options (for compatibiliy)}
}
\description{
Extract the scores (optimal objective values) of the evaluated DMUs
from a DEA fuzzy solution. Note that these scores may not always be interpreted
as efficiencies.
}
\examples{
# Replication results model DEA1 in Tomkins and Green (1988)
data("Departments")
# Calculate Total income
Departments$Total_income <- Departments[, 5] + Departments[, 6] + Departments[, 7] 
data_DEA1 <- read_data(Departments,
                       inputs = 9,
                       outputs = c(2, 3, 4, 12))
result <- model_basic(data_DEA1, 
                      orientation = "io",
                      rts = "crs")
efficiencies(result) # Table 3 (p.156) 
 
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
