% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/references.R
\name{references}
\alias{references}
\title{References}
\usage{
references(deasol,
           thr = 1e-4)
}
\arguments{
\item{deasol}{Object of class \code{dea} obtained with some of the DEA model functions.}

\item{thr}{Tolerance threshold (for avoiding miss detection of efficient 
DMUs due to round off errors)}
}
\description{
Extract the reference set for each DMU (inefficient DMUs and
efficicent DMUs that are combination of other efficient DMUs) from a DEA model solution.
}
\examples{
# Replication results model DEA1 in Tomkins and Green (1988).
data("Departments")
# Calculate Total income
Departments$Total_income <- Departments[, 5] + Departments[, 6] + Departments[, 7] 
data_DEA1 <- make_deadata(Departments,
                          inputs = 9,
                          outputs = c(2, 3, 4, 12))
result <- model_basic(data_DEA1, 
                      orientation = "io",
                      rts = "crs")
references(result) # Table 3 (p.157)

}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
