% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_evpi.R
\name{plot_evpi}
\alias{plot_evpi}
\title{Visualizing the results of Expected Value of Perfect Information (EVPI) analysis for various types of Monte Carlo simulation results}
\usage{
plot_evpi(
  EVPIresults,
  decision_vars,
  input_table = NULL,
  new_names = NULL,
  unit = NULL,
  x_axis_name = "Expected Value of Perfect Information",
  y_axis_name = NULL,
  bar_color = "cadetblue",
  base_size = 11,
  ...
)
}
\arguments{
\item{EVPIresults}{are the results of the \code{\link[decisionSupport:multi_EVPI]{multi_EVPI}} function}

\item{decision_vars}{are the names of the decision variables in the output of the \code{\link[decisionSupport:mcSimulation]{mcSimulation}} function}

\item{input_table}{is a data frame with at least two columns named 'variable' and 'label'. The 'variable column should have one entry for the name of each variable contained in any of the plots. In preparing the figure, the function will replace the variable names with the labels. If the label is missing then the plot will show 'NA' in the place of the variable name. Default is NULL and uses the original variable names.}

\item{new_names}{are the reformatted replacement names of the decision variables in the output of the \code{\link[decisionSupport:mcSimulation]{mcSimulation}} function}

\item{unit}{is the symbol to display before the evpi value on the x axis. It accepts text or (many) unicode formatted symbol text}

\item{x_axis_name}{is the name (character string) to be passed to the x-axis title. Default is "Expected Value of Perfect Information" and allows allow the user to add a customized axis title}

\item{y_axis_name}{is the name (character string) to be passed to the y-axis title. Default is NULL to allow the user to add a customized axis title}

\item{bar_color}{is the color to be used for the EVPI barplot. Default is "cadetblue"}

\item{base_size}{is the base text size to be used for the plot. The default is 11, this is the \code{\link[ggplot2:ggtheme]{ggplot2::ggtheme}} default}

\item{...}{accepts arguments to be passed to \code{\link[ggplot2:ggtheme]{ggplot2::ggtheme}}}
}
\value{
This function returns a plot of classes \code{'gg'}, 
and \code{'ggplot'}. This allows the user to
continue editing some features of the plots through the syntax 
\code{'+'}.
}
\description{
Plotting the Expected Value of Perfect Information (EVPI) of Monte Carlo outputs
}
\examples{

# Create a data.frame

montecarlo <- data.frame(indep1 = rnorm(1000, sd = 50, mean = 100), 
                         indep2 = rnorm(1000, sd = 100, mean = 100))
montecarlo[, 'output1'] <- montecarlo[, 'indep1'] * montecarlo[, 'indep2']
montecarlo[, 'output2'] <- (montecarlo[, 'indep1'] * (montecarlo[, 'indep2']) + 10)

# Run the multi_EVPI function 
 
results_all <- multi_EVPI(montecarlo,"output1")

plot_evpi(results_all, decision_vars = c("output1", "output2"), 
new_names = c("Decision option 1", "Decision option 2"))

}
\references{
Do, Hoa, Eike Luedeling, and Cory Whitney. “Decision Analysis of Agroforestry Options Reveals Adoption Risks for Resource-Poor Farmers.” Agronomy for Sustainable Development 40, no. 3 (June 2020): 20. \doi{10.1007/s13593-020-00624-5}.
Lanzanova, Denis, Cory Whitney, Keith Shepherd, and Eike Luedeling. “Improving Development Efficiency through Decision Analysis: Reservoir Protection in Burkina Faso.” Environmental Modelling & Software 115 (May 1, 2019): 164–75. \doi{10.1016/j.envsoft.2019.01.016}.
Luedeling, Eike, and Keith Shepherd. “Decision-Focused Agricultural Research.” Solutions 7, no. 5 (2016): 46–54. \url{https://thesolutionsjournal.com/2016/09/17/decision-focused-agricultural-research/}
}
\author{
Eduardo Fernandez (\email{efernand@uni-bonn.de})

Cory Whitney (\email{cory.whitney@uni-bonn.de})
}
\keyword{EVPI}
\keyword{Monte-Carlo}
\keyword{decision-analysis}
\keyword{decisionSupport}
\keyword{net-present-value}
\keyword{perfect-information}
\keyword{risk}
\keyword{uncertainty}
