% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_arc-layer.R
\name{add_arc_layer}
\alias{add_arc_layer}
\title{Add an arc layer to the deckgl widget}
\usage{
add_arc_layer(deckgl, id = "arc-layer", data = NULL,
  properties = list(), ...)
}
\arguments{
\item{deckgl}{A deckgl widget object.}

\item{id}{The unique id of the layer.}

\item{data}{The url to fetch data from or a data object.}

\item{properties}{A named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class.}

\item{...}{More properties that will be added to the \code{properties} object. This can be useful
if you want to use a properties object for more than one layer.}
}
\description{
The \code{ArcLayer} renders raised arcs joining pairs of source and target points,
specified as latitude/longitude coordinates.
}
\examples{
## @knitr arc-layer
data("bart_segments")

properties <- list(
  getWidth = 12,
  getSourcePosition = ~from_lng + from_lat,
  getTargetPosition = ~to_lng + to_lat,
  getSourceColor = JS("d => [Math.sqrt(d.inbound), 140, 0]"),
  getTargetColor = JS("d => [Math.sqrt(d.outbound), 140, 0]"),
  tooltip = use_tooltip(
    html = "{{from_name}} to {{to_name}}",
    style = "background: steelBlue; border-radius: 5px;"
  )
)

deck <- deckgl(zoom = 10, pitch = 35) \%>\%
  add_arc_layer(data = bart_segments, properties = properties) \%>\%
  add_control("Arc Layer", "top-left") \%>\%
  add_basemap()

if (interactive()) deck
}
\seealso{
\url{https://deck.gl/#/documentation/deckgl-api-reference/layers/arc-layer}
}
