% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.keyvalue.R, R/as.keyvalue.data.frame.R,
%   R/as.keyvalue.default.R, R/is.keyvalue.R
\name{keyvalue}
\alias{keyvalue}
\alias{as.keyvalue}
\alias{as.keyvalue.data.frame}
\alias{as.keyvalue.default}
\alias{is.keyvalue}
\title{Coerce to a keyvalue object}
\usage{
as.keyvalue(x, ...)

\method{as.keyvalue}{data.frame}(x, standard_var_names = NULL, ...)

\method{as.keyvalue}{default}(x, y, ...)

is.keyvalue(x)
}
\arguments{
\item{x}{object to test for, or coerce to, keyvalue (see the details).}

\item{...}{arguments passed between methods}

\item{standard_var_names}{a character vector with standard names for variables decoded with this key-values.}

\item{y}{a value vector if \code{x} is an unnamed vector (argument must be named 'y = .')}
}
\value{
\code{as.keyvalue} returns a data.frame with additional class \code{keyvalue} that fulfills the requirements
for a \code{keyvalue} object and with the \code{key} column as character. It also has two extra attributes
\code{standard_var_names} as described above and \code{keyvalue11} which is \code{TRUE} for keyvalue objects
with a 1:1 relation between its keys and values (otherwise FALSE).
}
\description{
Functions to check if an object is a keyvalue object, or coerce it if possible.
}
\details{
\code{x} can be of:
\itemize{
\item a name of a package internal (or external) keyvalue object 
(character of length one)
\item a \code{data.frame} with two columns "key" (with unique cells) and "value".
\item a list as described in \code{\link{as.keyvalue.list}}
\item a named vector with all names unique 
\item an unnamed vector with unique cells if supplemented by additional vector (y)
}
}
\examples{
snomed <- decoder:::snomed
snomed2 <- as.keyvalue(snomed)
is.keyvalue(snomed2)
summary(snomed2)
}
\seealso{
\link{as.keyvalue.list}, \link{decode}, \link{summary.keyvalue}, \link{key_and_value}
}
