% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_lang2.R
\name{toDutch2}
\alias{toDutch2}
\title{Translate texts into Dutch using DeepL}
\usage{
toDutch2(text, source_lang = NULL, get_detect = FALSE)
}
\arguments{
\item{text}{text to be translated. Must not exceed 5000 characters. Only UTF8-encoded plain text is supported.
May contain multiple sentences.}

\item{source_lang}{language of the text to be translated. Can be one of the following:
\itemize{
\item \code{EN} English
\item \code{DE} German
\item \code{FR} French
\item \code{ES} Spanish
\item \code{IT} Italian
\item \code{PL} Polish
 }
    If parameter \code{is.null}, the API will try to detect the language of the text.}

\item{get_detect}{if \code{TRUE}, the language detected for the source text is also inclued in the response. It corresponds to
the value of the argument \code{source_lang} if it was specified. If \code{FALSE}, only the translated text is returned.}
}
\value{
If \code{get_detect} is set to \code{FALSE} a \code{character vector} containing the translation
    is returned. Otherwise, a \code{data.frame} (\code{tibble::tibble}) is returned with the following columns:
\itemize{
\item \code{translation} the translated text(s).
\item \code{source_lang} detected or specified language of the input text.
}
}
\description{
\code{toDutch2} ranslates a text from English, German, French, Sapnish, Italian or Polish into Dutch
    using the undocumented JSON-RPC DeepL API. No authentication key is required to use this service.
}
\examples{
\donttest{
# Simple translation
toDutch2("Hallo Welt!")

# Customized translator applied to multiple strings
txt1 <- c("My name is Albert.", "I'm a physicist.", "I was born in 1879 in Ulm.")
purrr::map_chr(txt1, toDutch2)

# Customized translator applied to multiple strings (with language detection response)
txt2 <- c("Je m'appelle Jean.", "Ich bin Arzt.", "I'm from Wales")
translator2 <- function(t) toDutch2(text = t, get_detect = T)
purrr::map_df(txt2, translator2)

}

}
