% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deepregression.R
\name{keras_dr}
\alias{keras_dr}
\title{Compile a Deep Distributional Regression Model}
\usage{
keras_dr(
  list_pred_param,
  weights = NULL,
  optimizer = tf$keras$optimizers$Adam(),
  model_fun = keras_model,
  monitor_metrics = list(),
  from_preds_to_output = from_preds_to_dist,
  loss = from_dist_to_loss(family = list(...)$family, weights = weights),
  additional_penalty = NULL,
  ...
)
}
\arguments{
\item{list_pred_param}{list of input-output(-lists) generated from
\code{subnetwork_init}}

\item{weights}{vector of positive values; optional (default = 1 for all observations)}

\item{optimizer}{optimizer used. Per default Adam}

\item{model_fun}{which function to use for model building (default \code{keras_model})}

\item{monitor_metrics}{Further metrics to monitor}

\item{from_preds_to_output}{function taking the list_pred_param outputs
and transforms it into a single network output}

\item{loss}{the model's loss function; per default evaluated based on
the arguments \code{family} and \code{weights} using \code{from_dist_to_loss}}

\item{additional_penalty}{a penalty that is added to the negative log-likelihood;
must be a function of model$trainable_weights with suitable subsetting}

\item{...}{arguments passed to \code{from_preds_to_output}}
}
\value{
a list with input tensors and output tensors that can be passed
to, e.g., \code{keras_model}
}
\description{
Compile a Deep Distributional Regression Model
}
