#' Eon data from the International Commission on Stratigraphy (v2013-1)
#'
#' A dataset containing the boundary ages, abbreviations, and colors for the eons of the Geologic Time Scale.
#' Based on The ICS International Chronostratigraphic Chart (2013), by Cohen, Finney, Gibbard, and Fan.
#'
#' @format A data frame with 4 rows and 5 variables:
#' \describe{
#'   \item{name}{eon name}
#'   \item{max_age}{maximum age, in millions of years}
#'   \item{min_age}{minimum age, in millions of years}
#'   \item{abbr}{eon name abbreviations}
#'   \item{color}{the colors for each eon, according to the Commission for the Geological Map of the World}
#' }
#' @source \url{https://stratigraphy.org/ICSchart/Cohen2013_Episodes.pdf} via \url{https://paleobiodb.org/data1.2/intervals/list.txt?scale_id=1&scale_level=1}
"eons"

#' Era data from the International Commission on Stratigraphy (v2013-1)
#'
#' A dataset containing the boundary ages, abbreviations, and colors for the eras of the Geologic Time Scale.
#' Based on The ICS International Chronostratigraphic Chart (2013), by Cohen, Finney, Gibbard, and Fan.
#'
#' @format A data frame with 10 rows and 5 variables:
#' \describe{
#'   \item{name}{era name}
#'   \item{max_age}{maximum age, in millions of years}
#'   \item{min_age}{minimum age, in millions of years}
#'   \item{abbr}{era name abbreviations}
#'   \item{color}{the colors for each era, according to the Commission for the Geological Map of the World}
#' }
#' @source \url{https://stratigraphy.org/ICSchart/Cohen2013_Episodes.pdf} via \url{https://paleobiodb.org/data1.2/intervals/list.txt?scale_id=1&scale_level=2}
"eras"

#' Period data from the International Commission on Stratigraphy (v2013-1)
#'
#' A dataset containing the boundary ages, abbreviations, and colors for the periods of the Geologic Time Scale.
#' Based on The ICS International Chronostratigraphic Chart (2013), by Cohen, Finney, Gibbard, and Fan.
#'
#' @format A data frame with 22 rows and 5 variables:
#' \describe{
#'   \item{name}{period name}
#'   \item{max_age}{maximum age, in millions of years}
#'   \item{min_age}{minimum age, in millions of years}
#'   \item{abbr}{period name abbreviations}
#'   \item{color}{the colors for each period, according to the Commission for the Geological Map of the World}
#' }
#' @source \url{https://stratigraphy.org/ICSchart/Cohen2013_Episodes.pdf} via \url{https://paleobiodb.org/data1.2/intervals/list.txt?scale_id=1&scale_level=3}
"periods"

#' Epoch data from the International Commission on Stratigraphy (v2013-1)
#'
#' A dataset containing the boundary ages, abbreviations, and colors for the epochs of the Geologic Time Scale.
#' Based on The ICS International Chronostratigraphic Chart (2013), by Cohen, Finney, Gibbard, and Fan.
#'
#' @format A data frame with 34 rows and 5 variables:
#' \describe{
#'   \item{name}{epoch name}
#'   \item{max_age}{maximum age, in millions of years}
#'   \item{min_age}{minimum age, in millions of years}
#'   \item{abbr}{epoch name abbreviations}
#'   \item{color}{the colors for each epoch, according to the Commission for the Geological Map of the World}
#' }
#' @source \url{https://stratigraphy.org/ICSchart/Cohen2013_Episodes.pdf} via \url{https://paleobiodb.org/data1.2/intervals/list.txt?scale_id=1&scale_level=4}
"epochs"

#' Stage data from the International Commission on Stratigraphy (v2013-1)
#'
#' A dataset containing the boundary ages, abbreviations, and colors for the stages of the Geologic Time Scale.
#' Based on The ICS International Chronostratigraphic Chart (2013), by Cohen, Finney, Gibbard, and Fan.
#'
#' @format A data frame with 100 rows and 5 variables:
#' \describe{
#'   \item{name}{stage name}
#'   \item{max_age}{maximum age, in millions of years}
#'   \item{min_age}{minimum age, in millions of years}
#'   \item{abbr}{stage name abbreviations}
#'   \item{color}{the colors for each stage, according to the Commission for the Geological Map of the World}
#' }
#' @source \url{https://stratigraphy.org/ICSchart/Cohen2013_Episodes.pdf} via \url{https://paleobiodb.org/data1.2/intervals/list.txt?scale_id=1&scale_level=5}
"stages"
