% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif_census.R
\name{motif_census}
\alias{motif_census}
\alias{defm_motif_census}
\title{Motif census}
\usage{
motif_census(m, locs)
}
\arguments{
\item{m}{An object of class \link{DEFM}.}

\item{locs}{Idx (starting from zero) with the variables that will be
included in the census.}
}
\value{
A matrix of class \link{defm_motif_census} with the motif counts.
}
\description{
Calculates the total motif counts for a given model, in terms
of the number of times each motif appears in the data.
}
\examples{
# Loading Valente's SNS data
data(valentesnsList)

mymodel <- new_defm(
  id = valentesnsList$id,
  Y = valentesnsList$Y,
  X = valentesnsList$X,
  order = 1
)

# Adding the intercept terms and a motif from tobacco to mj
term_defm_logit_intercept(mymodel)
term_defm_transition_formula(mymodel, "{y1, 0y2} > {y1, y2}")

# Initialize the model
init_defm(mymodel)

# Motif counts featuring only the first two variables
motif_census(mymodel, locs = 0:1)
}
\references{
Vega Yon, G. G., Pugh, M. J., & Valente, T. W. (2022). Discrete Exponential-Family Models for Multivariate Binary Outcomes (arXiv:2211.00627). arXiv. \url{https://arxiv.org/abs/2211.00627}
}
