/*
 * Decompiled with CFR 0.152.
 */
package ch.fgcz.proteomics.dto;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class MassSpectrum {
    private String typ;
    private String searchEngine;
    private List<Double> mz = new ArrayList<Double>();
    private List<Double> intensity = new ArrayList<Double>();
    private List<Integer> charge = new ArrayList<Integer>();
    private List<Double> isotope = new ArrayList<Double>();
    private double peptideMass;
    private double rt;
    private int chargeState;
    private int id;

    public double[] getMzArray() {
        double[] mzarray = new double[this.mz.size()];
        for (int i = 0; i < mzarray.length; ++i) {
            mzarray[i] = this.mz.get(i);
        }
        return mzarray;
    }

    public double[] getIntensityArray() {
        double[] intarray = new double[this.intensity.size()];
        for (int i = 0; i < intarray.length; ++i) {
            intarray[i] = this.intensity.get(i);
        }
        return intarray;
    }

    public List<Integer> getCharge() {
        return this.charge;
    }

    public List<Double> getIsotope() {
        return this.isotope;
    }

    public List<Double> getMz() {
        return this.mz;
    }

    public void setMz(List<Double> mz) {
        this.mz = mz;
    }

    public List<Double> getIntensity() {
        return this.intensity;
    }

    public void setIntensity(List<Double> intensity) {
        this.intensity = intensity;
    }

    public int getId() {
        return this.id;
    }

    public String getTyp() {
        return this.typ;
    }

    public String getSearchEngine() {
        return this.searchEngine;
    }

    public double getPeptideMass() {
        return this.peptideMass;
    }

    public void setPeptideMass(double peptidMass) {
        this.peptideMass = peptidMass;
    }

    public double getRt() {
        return this.rt;
    }

    public int getChargeState() {
        return this.chargeState;
    }

    public void setChargeState(int chargeState) {
        this.chargeState = chargeState;
    }

    public MassSpectrum() {
        this.mz = new ArrayList<Double>();
        this.intensity = new ArrayList<Double>();
        this.charge = new ArrayList<Integer>();
        this.isotope = new ArrayList<Double>();
        this.typ = null;
        this.searchEngine = null;
        this.id = 0;
        this.rt = 0.0;
        this.chargeState = 0;
        this.peptideMass = 0.0;
    }

    public MassSpectrum(String typ, String searchEngine, List<Double> mz, List<Double> intensity, double peptidMass, double rt, int chargeState, int id) {
        if (!MassSpectrum.isSorted(mz)) {
            throw new IllegalArgumentException("The mZ-values are not sorted!");
        }
        this.mz = mz;
        this.intensity = intensity;
        this.charge = new ArrayList<Integer>();
        this.isotope = new ArrayList<Double>();
        this.typ = typ;
        this.searchEngine = searchEngine;
        this.id = id;
        this.rt = rt;
        this.chargeState = chargeState;
        this.peptideMass = peptidMass;
    }

    public MassSpectrum(String typ, String searchEngine, List<Double> mz, List<Double> intensity, double peptidMass, double rt, int chargeState, int id, List<Integer> charge, List<Double> isotope) {
        if (!MassSpectrum.isSorted(mz)) {
            throw new IllegalArgumentException("The mZ-values are not sorted!");
        }
        this.mz = mz;
        this.intensity = intensity;
        this.charge = charge;
        this.isotope = isotope;
        this.typ = typ;
        this.searchEngine = searchEngine;
        this.id = id;
        this.rt = rt;
        this.chargeState = chargeState;
        this.peptideMass = peptidMass;
    }

    private static boolean isSorted(List<Double> list) {
        return list.stream().sorted().collect(Collectors.toList()).equals(list);
    }
}

