/*
 * Decompiled with CFR 0.152.
 */
package ch.fgcz.proteomics.fbdm;

import ch.fgcz.proteomics.fbdm.Configuration;
import ch.fgcz.proteomics.fbdm.Connection;
import ch.fgcz.proteomics.fbdm.IsotopicCluster;
import ch.fgcz.proteomics.fbdm.Peak;
import ch.fgcz.proteomics.fbdm.PeakList;
import ch.fgcz.proteomics.fbdm.Score;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.shortestpath.KShortestPaths;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;

public class IsotopicClusterGraph {
    private double minimum = Double.MAX_VALUE;
    private DefaultDirectedWeightedGraph<IsotopicCluster, Connection> isotopicClusterGraph = new DefaultDirectedWeightedGraph(Connection.class);

    public DefaultDirectedWeightedGraph<IsotopicCluster, Connection> getIsotopicClusterGraph() {
        return this.isotopicClusterGraph;
    }

    public GraphPath<IsotopicCluster, Connection> bestPath(IsotopicCluster startCluster, IsotopicCluster endCluster) {
        KShortestPaths kPaths = new KShortestPaths(this.isotopicClusterGraph, 999999);
        List paths = kPaths.getPaths((Object)startCluster, (Object)endCluster);
        HashSet<Double> weights = new HashSet<Double>();
        for (GraphPath path : paths) {
            weights.add(path.getWeight());
        }
        if (weights.size() == 1 && paths.size() != 1) {
            System.err.println("WARNING: All scores are the same, therefore there is no valid best path! Please check if your input mass spectrum is correct! This could have a minimal impact on the results.");
        }
        return (GraphPath)paths.get(paths.size() - 1);
    }

    public String toDOTGraph() {
        StringBuilder stringBuilder = new StringBuilder();
        String lineSep = System.getProperty("line.separator");
        stringBuilder.append("digraph {").append(lineSep);
        stringBuilder.append("rankdir=LR;").append(lineSep);
        stringBuilder.append("node [shape=box];").append(lineSep);
        for (Connection connection : this.isotopicClusterGraph.edgeSet()) {
            if (((IsotopicCluster)this.isotopicClusterGraph.getEdgeSource((Object)connection)).isNotNull() && ((IsotopicCluster)this.isotopicClusterGraph.getEdgeTarget((Object)connection)).isNotNull()) {
                stringBuilder.append("\"(" + ((IsotopicCluster)this.isotopicClusterGraph.getEdgeSource((Object)connection)).getClusterID() + ") [ ");
                for (Peak peak : ((IsotopicCluster)this.isotopicClusterGraph.getEdgeSource((Object)connection)).getIsotopicCluster()) {
                    stringBuilder.append(" (" + peak.getPeakID() + ") " + (double)Math.round(peak.getMz() * 100.0) / 100.0 + " ");
                }
                stringBuilder.append("] z:" + ((IsotopicCluster)this.isotopicClusterGraph.getEdgeSource((Object)connection)).getCharge() + "\" -> \"(" + ((IsotopicCluster)this.isotopicClusterGraph.getEdgeTarget((Object)connection)).getClusterID() + ") [ ");
                for (Peak peak : ((IsotopicCluster)this.isotopicClusterGraph.getEdgeTarget((Object)connection)).getIsotopicCluster()) {
                    stringBuilder.append(" (" + peak.getPeakID() + ") " + (double)Math.round(peak.getMz() * 100.0) / 100.0 + " ");
                }
                stringBuilder.append("] z:" + ((IsotopicCluster)this.isotopicClusterGraph.getEdgeTarget((Object)connection)).getCharge() + "\"").append("[color=\"" + connection.getColor() + "\",label=\"" + (double)Math.round(connection.getScore() * 10000.0) / 10000.0 + "\",weight=\"" + connection.getScore() + "\"];").append(lineSep);
                continue;
            }
            if (((IsotopicCluster)this.isotopicClusterGraph.getEdgeSource((Object)connection)).isNull() && ((IsotopicCluster)this.isotopicClusterGraph.getEdgeTarget((Object)connection)).isNotNull()) {
                stringBuilder.append(((IsotopicCluster)this.isotopicClusterGraph.getEdgeSource((Object)connection)).getStatus());
                stringBuilder.append(" -> \"(" + ((IsotopicCluster)this.isotopicClusterGraph.getEdgeTarget((Object)connection)).getClusterID() + ") [ ");
                for (Peak peak : ((IsotopicCluster)this.isotopicClusterGraph.getEdgeTarget((Object)connection)).getIsotopicCluster()) {
                    stringBuilder.append(" (" + peak.getPeakID() + ") " + (double)Math.round(peak.getMz() * 100.0) / 100.0 + " ");
                }
                stringBuilder.append("] z:" + ((IsotopicCluster)this.isotopicClusterGraph.getEdgeTarget((Object)connection)).getCharge() + "\"").append("[color=\"" + connection.getColor() + "\",label=\"" + (double)Math.round(connection.getScore() * 10000.0) / 10000.0 + "\",weight=\"" + connection.getScore() + "\"];").append(lineSep);
                continue;
            }
            if (!((IsotopicCluster)this.isotopicClusterGraph.getEdgeTarget((Object)connection)).isNull() || !((IsotopicCluster)this.isotopicClusterGraph.getEdgeSource((Object)connection)).isNotNull()) continue;
            stringBuilder.append("\"(" + ((IsotopicCluster)this.isotopicClusterGraph.getEdgeSource((Object)connection)).getClusterID() + ") [ ");
            for (Peak peak : ((IsotopicCluster)this.isotopicClusterGraph.getEdgeSource((Object)connection)).getIsotopicCluster()) {
                stringBuilder.append(" (" + peak.getPeakID() + ") " + (double)Math.round(peak.getMz() * 100.0) / 100.0 + " ");
            }
            stringBuilder.append("] z:" + ((IsotopicCluster)this.isotopicClusterGraph.getEdgeSource((Object)connection)).getCharge() + "\" -> " + ((IsotopicCluster)this.isotopicClusterGraph.getEdgeTarget((Object)connection)).getStatus()).append("[color=\"" + connection.getColor() + "\",label=\"" + (double)Math.round(connection.getScore() * 10000.0) / 10000.0 + "\",weight=\"" + connection.getScore() + "\"];").append(lineSep);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public IsotopicClusterGraph(List<IsotopicCluster> isotopicSet) {
        this.minimum = Double.MAX_VALUE;
        isotopicSet.add(new IsotopicCluster("start"));
        for (IsotopicCluster isotopicCluster : isotopicSet) {
            for (IsotopicCluster cluster2 : isotopicSet) {
                String color = this.calculateConnection(isotopicCluster, cluster2);
                if (color != null && isotopicCluster.isNull() && cluster2.isNotNull()) {
                    this.connectClusters(isotopicCluster, cluster2, color);
                }
                if (color == null || !isotopicCluster.isNotNull() || !cluster2.isNotNull()) continue;
                this.connectClusters(isotopicCluster, cluster2, color);
            }
        }
        ArrayList<IsotopicCluster> isotopicClusters = new ArrayList<IsotopicCluster>();
        for (IsotopicCluster cluster1 : this.isotopicClusterGraph.vertexSet()) {
            int edgeCount = 0;
            for (IsotopicCluster cluster2 : this.isotopicClusterGraph.vertexSet()) {
                edgeCount += this.isotopicClusterGraph.getAllEdges((Object)cluster1, (Object)cluster2).size();
            }
            if (edgeCount != 0) continue;
            isotopicClusters.add(cluster1);
        }
        IsotopicCluster isotopicCluster = new IsotopicCluster("end");
        for (IsotopicCluster cluster : isotopicClusters) {
            this.connectClusters(cluster, isotopicCluster, "black");
        }
    }

    public void scoreIsotopicClusterGraph(double peptidMass, int chargeState, PeakList peakList, Configuration config) {
        Score score = new Score(peptidMass, chargeState, this.isotopicClusterGraph, config);
        for (Connection connection : this.isotopicClusterGraph.edgeSet()) {
            double scoreSum = 0.0;
            if (!((IsotopicCluster)this.isotopicClusterGraph.getEdgeTarget((Object)connection)).isNotNull()) continue;
            for (Peak peakX : ((IsotopicCluster)this.isotopicClusterGraph.getEdgeTarget((Object)connection)).getIsotopicCluster()) {
                for (Peak peakY : peakList.getPeakList()) {
                    if (peakX.getMz() > peakY.getMz()) continue;
                    double scoreResult = score.calculateScore(peakX, peakY, (IsotopicCluster)this.isotopicClusterGraph.getEdgeTarget((Object)connection), connection);
                    scoreSum += scoreResult;
                }
            }
            connection.setScore(scoreSum);
            this.isotopicClusterGraph.setEdgeWeight((Object)connection, scoreSum);
        }
    }

    public IsotopicCluster getStart() {
        for (IsotopicCluster cluster : this.isotopicClusterGraph.vertexSet()) {
            if (!cluster.isNull() || cluster.getStatus() != "start") continue;
            return cluster;
        }
        return null;
    }

    public IsotopicCluster getEnd() {
        for (IsotopicCluster cluster : this.isotopicClusterGraph.vertexSet()) {
            if (!cluster.isNull() || cluster.getStatus() != "end") continue;
            return cluster;
        }
        return null;
    }

    private void connectClusters(IsotopicCluster cluster1, IsotopicCluster cluster2, String color) {
        this.isotopicClusterGraph.addVertex((Object)cluster1);
        this.isotopicClusterGraph.addVertex((Object)cluster2);
        Connection connection = new Connection(color);
        this.isotopicClusterGraph.addEdge((Object)cluster1, (Object)cluster2, (Object)connection);
    }

    private String calculateConnection(IsotopicCluster cluster1, IsotopicCluster cluster2) {
        if (cluster1.isNotNull() && cluster1.getPeak(0).getMz() < this.minimum) {
            this.minimum = cluster1.getPeak(0).getMz();
        }
        if (cluster1.getStatus() == "start" && cluster2.isNotNull() && cluster1.isNull() && cluster2.getPeak(0).getMz() == this.minimum) {
            return "black";
        }
        if (cluster1.isNull() || cluster2.isNull()) {
            return null;
        }
        if (cluster1.getPeak(cluster1.size() - 1).getMz() < cluster2.getPeak(0).getMz()) {
            return "black";
        }
        if (cluster1.getPeak(0).getMz() < cluster2.getPeak(0).getMz() && (cluster1.size() == 2 ? cluster1.getPeak(1).getMz() == cluster2.getPeak(0).getMz() : (cluster1.size() == 3 ? cluster1.getPeak(1).getMz() == cluster2.getPeak(0).getMz() || cluster1.getPeak(2).getMz() == cluster2.getPeak(0).getMz() : cluster1.size() == 3 && cluster1.getPeak(1).getMz() == cluster2.getPeak(0).getMz() && cluster1.getPeak(2).getMz() == cluster2.getPeak(1).getMz()))) {
            return "red";
        }
        return null;
    }
}

