/*
 * Decompiled with CFR 0.152.
 */
package ch.fgcz.proteomics.fbdm;

import ch.fgcz.proteomics.dto.MassSpectrum;
import ch.fgcz.proteomics.dto.MassSpectrumMetaInformation;
import ch.fgcz.proteomics.fbdm.Configuration;
import ch.fgcz.proteomics.fbdm.Peak;
import ch.fgcz.proteomics.utilities.MathUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;

public class PeakList
implements MassSpectrumMetaInformation {
    private double peptideMass;
    private int chargeState;
    private List<Peak> peakList = new ArrayList<Peak>();

    public boolean isEmpty() {
        return this.peakList.isEmpty();
    }

    public void setPeakList(List<Peak> peakList) {
        this.peakList = peakList;
    }

    public List<Peak> getPeakList() {
        return this.peakList;
    }

    public PeakList() {
        this.chargeState = 0;
        this.peptideMass = 0.0;
        this.peakList = new ArrayList<Peak>();
    }

    public PeakList(MassSpectrum massSpectrum) {
        this.peptideMass = massSpectrum.getPeptideMass();
        this.chargeState = massSpectrum.getChargeState();
        ArrayList<Peak> plist = new ArrayList<Peak>();
        for (int i = 0; i < massSpectrum.getMz().size() || i < massSpectrum.getIntensity().size(); ++i) {
            plist.add(new Peak(massSpectrum.getMz().get(i), massSpectrum.getIntensity().get(i), i));
        }
        this.peakList = plist;
    }

    public PeakList add(Peak peak) {
        this.peakList.add(peak);
        return this;
    }

    public Peak get(int i) {
        return this.peakList.get(i);
    }

    public void addAll(PeakList peakList) {
        this.peakList.addAll(peakList.peakList);
    }

    public void addAll(List<Peak> peakList) {
        this.peakList.addAll(peakList);
    }

    public int size() {
        return this.peakList.size();
    }

    public PeakList(List<Peak> peaks) {
        this.peakList = peaks;
    }

    public PeakList mergePeakLists(PeakList peakList2) {
        PeakList notInIsotopicSet = new PeakList();
        for (Peak peak : this.peakList) {
            if (peak.isInSet()) continue;
            notInIsotopicSet.add(peak);
        }
        notInIsotopicSet.addAll(peakList2);
        return notInIsotopicSet;
    }

    public double sumIntensities() {
        double intensitySum = 0.0;
        for (Peak peak : this.peakList) {
            intensitySum += peak.getIntensity();
        }
        return intensitySum;
    }

    public PeakList dechargePeaks(double H_MASS) {
        PeakList peaklistDecharged = new PeakList();
        for (int i = 0; i < this.peakList.size(); ++i) {
            if (this.peakList.get(i).getCharge() > 1) {
                peaklistDecharged.getPeakList().add(new Peak(this.peakList.get(i).getMz() * (double)this.peakList.get(i).getCharge() - (double)(this.peakList.get(i).getCharge() - 1) * H_MASS, this.peakList.get(i).getIntensity(), this.peakList.get(i).getIsotope(), 1, this.peakList.get(i).getPeakID(), this.peakList.get(i).getIsotopicClusterID(), this.peakList.get(i).getIsotopicSetID()));
                continue;
            }
            peaklistDecharged.getPeakList().add(new Peak(this.peakList.get(i).getMz(), this.peakList.get(i).getIntensity(), this.peakList.get(i).getIsotope(), this.peakList.get(i).getCharge(), this.peakList.get(i).getPeakID(), this.peakList.get(i).getIsotopicClusterID(), this.peakList.get(i).getIsotopicSetID()));
        }
        return peaklistDecharged;
    }

    public PeakList filterNoisePeaks(double noise) {
        ArrayList<Double> intensity = new ArrayList<Double>();
        for (Peak peak : this.peakList) {
            intensity.add(peak.getIntensity());
        }
        double threshold = (Double)Collections.max(intensity) * noise / 100.0;
        PeakList peaklistNoise = new PeakList();
        for (int i = 0; i < this.peakList.size(); ++i) {
            if (!(threshold < this.peakList.get(i).getIntensity())) continue;
            peaklistNoise.getPeakList().add(this.peakList.get(i));
        }
        return peaklistNoise;
    }

    public String saveAnnotatedSpectrum() {
        StringBuilder stringBuilder = new StringBuilder();
        String lineSep = System.getProperty("line.separator");
        stringBuilder.append("IsotopicSet,IsotopicCluster,Peak,Charge,mZ,Intensity").append(lineSep);
        for (Peak peak : this.peakList) {
            stringBuilder.append(peak.getIsotopicSetID()).append(",").append(peak.getIsotopicClusterID()).append(",").append(peak.getPeakID()).append(",").append(peak.getCharge()).append(",").append(peak.getMz()).append(",").append(peak.getIntensity()).append(lineSep);
        }
        return stringBuilder.toString();
    }

    public PeakList sortByMZ() {
        Collections.sort(this.peakList, new Comparator<Peak>(){

            @Override
            public int compare(Peak peakOne, Peak peakTwo) {
                return Double.compare(peakOne.getMz(), peakTwo.getMz());
            }
        });
        return this;
    }

    public PeakList removeMultiplePeaks() {
        ListIterator<Peak> peakListIterator = this.peakList.listIterator();
        block0: while (peakListIterator.hasNext()) {
            int index = peakListIterator.nextIndex();
            Peak currentPeak = peakListIterator.next();
            for (int j = 0; j < index; ++j) {
                if (!currentPeak.equals(this.peakList.get(j))) continue;
                peakListIterator.remove();
                continue block0;
            }
        }
        return this;
    }

    public PeakList collectForEachCharge(Peak peakI, Peak peakJ, Configuration config) {
        for (int charge = 1; charge < 4; ++charge) {
            double lowerThreshold = peakI.getMz() + config.getIsotopicPeakDistance() / (double)charge - config.getDelta();
            double higherThreshold = peakI.getMz() + config.getIsotopicPeakDistance() / (double)charge + config.getDelta();
            if (!(lowerThreshold < peakJ.getMz()) || !(peakJ.getMz() < higherThreshold)) continue;
            peakI.setInSet(true);
            peakJ.setInSet(true);
            this.add(peakI);
            this.add(peakJ);
        }
        return this;
    }

    public PeakList sortByPeakID() {
        Collections.sort(this.peakList, new Comparator<Peak>(){

            @Override
            public int compare(Peak peakOne, Peak peakTwo) {
                return Double.compare(peakOne.getPeakID(), peakTwo.getPeakID());
            }
        });
        return this;
    }

    public boolean isSortedByMass() {
        boolean sorted = true;
        for (int i = 1; i < this.peakList.size(); ++i) {
            if (!(this.peakList.get(i - 1).getMz() > this.peakList.get(i).getMz())) continue;
            sorted = false;
        }
        return sorted;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Peak peak : this.peakList) {
            stringBuilder.append(peak.toString()).append(System.getProperty("line.separator"));
        }
        return "PeakList: " + System.getProperty("line.separator") + stringBuilder.toString();
    }

    public static void checkForIntensityCorrectness(PeakList peakList1, PeakList peakList2) throws IllegalStateException {
        double sumAfter;
        double sumBefore = peakList1.sumIntensities();
        if (!MathUtils.fuzzyEqual(sumBefore, sumAfter = peakList2.sumIntensities(), 0.001)) {
            throw new IllegalStateException("Wrong intensities (Intensity before: " + sumBefore + " and after: " + sumAfter + "!");
        }
    }

    @Override
    public double getPeptideMass() {
        return this.peptideMass;
    }

    @Override
    public int getChargeState() {
        return this.chargeState;
    }
}

