/*
 * Decompiled with CFR 0.152.
 */
package ch.fgcz.proteomics.fbdm;

import ch.fgcz.proteomics.fbdm.ScoringConfiguration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Configuration
implements ScoringConfiguration {
    private Map<String, Double> aaMass = new HashMap<String, Double>();
    private Map<String, Double> aaMassDividedTwo = new HashMap<String, Double>();
    private Map<String, Double> aaMassDividedThree = new HashMap<String, Double>();
    private double minimum = 0.0;
    private double maximum = Double.MAX_VALUE;
    private double f1 = 0.8;
    private double f2 = 0.5;
    private double f3 = 0.1;
    private double f4 = 0.1;
    private double f5 = 0.1;
    private double distance = 1.00048;
    private double errortolerance = 0.3;
    private double delta = 0.003;
    private double noise = 0.0;
    private boolean decharge = false;
    private String modus = "first";
    private static final double H_MASS = 1.008;
    private static final double NH3_MASS = 17.03052;
    private static final double H2O_MASS = 18.01528;
    private static final double NH_MASS = 15.01464;
    private static final double CO_MASS = 28.0101;
    private static final double PHE_MASS = 165.192;
    private static final double ASP_MASS = 133.104;
    private static final double AVE_UPDATED_MASS = 111.125;

    @Override
    public double getF(int f) {
        switch (f) {
            case 1: {
                return this.f1;
            }
            case 2: {
                return this.f2;
            }
            case 3: {
                return this.f3;
            }
            case 4: {
                return this.f4;
            }
            case 5: {
                return this.f5;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setF(int f, double value) {
        switch (f) {
            case 1: {
                this.f1 = value;
                break;
            }
            case 2: {
                this.f2 = value;
                break;
            }
            case 3: {
                this.f3 = value;
                break;
            }
            case 4: {
                this.f4 = value;
                break;
            }
            case 5: {
                this.f5 = value;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public boolean isDecharge() {
        return this.decharge;
    }

    public String getModus() {
        return this.modus;
    }

    @Override
    public double getErrorTolerance() {
        return this.errortolerance;
    }

    public double getDelta() {
        return this.delta;
    }

    public double getNoise() {
        return this.noise;
    }

    @Override
    public double getIsotopicPeakDistance() {
        return this.distance;
    }

    @Override
    public double getHMass(int multiplier) {
        return 1.008 * (double)multiplier;
    }

    @Override
    public double getNh3Mass(int charge) {
        return 17.03052 / (double)charge;
    }

    @Override
    public double getH2oMass(int charge) {
        return 18.01528 / (double)charge;
    }

    @Override
    public double getNhMass(int charge) {
        return 15.01464 / (double)charge;
    }

    @Override
    public double getCoMass(int charge) {
        return 28.0101 / (double)charge;
    }

    public double getPheMass() {
        return 165.192;
    }

    public double getAspMass() {
        return 133.104;
    }

    public double getAveUpdatedMass() {
        return 111.125;
    }

    @Override
    public double getMin() {
        return this.minimum;
    }

    @Override
    public double getMax() {
        return this.maximum;
    }

    @Override
    public Map<String, Double> getAaMass() {
        return this.aaMass;
    }

    @Override
    public Map<String, Double> getAaMassDividedTwo() {
        return this.aaMassDividedTwo;
    }

    @Override
    public Map<String, Double> getAaMassDividedThree() {
        return this.aaMassDividedThree;
    }

    public Configuration() {
        this(0.003, 0.3, 1.00048, 0.0, false, "first");
    }

    public Configuration(double delta, double errortolerance, double distance, double noise, boolean decharge, String modus) {
        this(Configuration.initializeStandartAminoAcidMasses(), delta, errortolerance, distance, noise, decharge, modus);
    }

    public Configuration(Map<String, Double> aaMass, double delta, double errortolerance, double distance, double noise, boolean decharge, String modus) {
        this.delta = delta;
        this.errortolerance = errortolerance;
        this.distance = distance;
        this.noise = noise;
        this.decharge = decharge;
        this.aaMass = aaMass;
        this.modus = modus;
        for (Map.Entry<String, Double> entry : aaMass.entrySet()) {
            this.aaMassDividedTwo.put(entry.getKey(), entry.getValue() / 2.0);
            this.aaMassDividedThree.put(entry.getKey(), entry.getValue() / 3.0);
        }
        this.minimum = Collections.min(this.aaMassDividedThree.values());
        this.maximum = Collections.max(this.aaMass.values());
    }

    public String toString() {
        return "Configuration,Value\nF1," + this.f1 + "\nF2," + this.f2 + "\nF3," + this.f3 + "\nF4," + this.f4 + "\nF5," + this.f5 + "\nDistance," + this.distance + "\nErrortolerance," + this.errortolerance + "\nDelta," + this.delta + "\nNoise," + this.noise + "\nDecharge," + this.decharge + "\nModus," + this.modus + "\nH Mass," + 1.008 + "\nNH3 Mass," + 17.03052 + "\nH2O Mass," + 18.01528 + "\nNH Mass," + 15.01464 + "\nCO Mass," + 28.0101 + "\nPhenylalanine Mass," + 165.192 + "\nAspartic Acid Mass," + 133.104 + "\nUpdated Averagine Mass," + 111.125 + "\nAmino Acid Masses," + this.print(this.aaMass);
    }

    private String print(Map<String, Double> aaMass) {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append("[");
        for (Map.Entry<String, Double> entry : aaMass.entrySet()) {
            stringbuilder.append(" " + entry.getKey() + "=" + entry.getValue());
        }
        stringbuilder.append(" ]");
        return stringbuilder.toString();
    }

    private static Map<String, Double> initializeStandartAminoAcidMasses() {
        HashMap<String, Double> aaMass = new HashMap<String, Double>();
        aaMass.put("A", 71.03711);
        aaMass.put("R", 156.10111);
        aaMass.put("N", 114.04293);
        aaMass.put("D", 115.02694);
        aaMass.put("C", 103.00919);
        aaMass.put("E", 129.04259);
        aaMass.put("Q", 128.05858);
        aaMass.put("G", 57.02146);
        aaMass.put("H", 137.05891);
        aaMass.put("I", 113.08406);
        aaMass.put("L", 113.08406);
        aaMass.put("K", 128.09496);
        aaMass.put("M", 131.04049);
        aaMass.put("F", 147.06841);
        aaMass.put("P", 97.05276);
        aaMass.put("S", 87.03203);
        aaMass.put("T", 101.04768);
        aaMass.put("W", 186.07931);
        aaMass.put("Y", 163.06333);
        aaMass.put("V", 99.06841);
        return aaMass;
    }
}

