/*
 * Decompiled with CFR 0.152.
 */
package ch.fgcz.proteomics.fbdm;

import ch.fgcz.proteomics.fbdm.Configuration;
import ch.fgcz.proteomics.fbdm.IsotopicCluster;
import ch.fgcz.proteomics.fbdm.IsotopicSet;
import ch.fgcz.proteomics.fbdm.Peak;
import ch.fgcz.proteomics.fbdm.PeakList;
import ch.fgcz.proteomics.utilities.MathUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Deisotoper {
    private boolean running = false;
    private PeakList peakList;
    private Configuration config;
    private List<IsotopicSet> isotopicSets = new ArrayList<IsotopicSet>();

    public Deisotoper() {
        this(new Configuration());
    }

    public Deisotoper(Configuration config) {
        this.config = config;
    }

    public PeakList deisotopeMS(PeakList peakList) {
        this.peakList = peakList;
        this.running = true;
        this.isotopicSets = new ArrayList<IsotopicSet>();
        this.isotopicSets = Deisotoper.generateIsotopicSets(this.peakList, this.config);
        List<IsotopicCluster> bestClusters = this.getBestClusters();
        PeakList peakListAggregated = this.aggregate(bestClusters, this.config.getModus());
        if (this.config.isDecharge()) {
            peakListAggregated = peakListAggregated.dechargePeaks(this.config.getHMass(1));
        }
        PeakList mergedPeakList = this.peakList.mergePeakLists(peakListAggregated);
        if (this.config.getNoise() != 0.0) {
            mergedPeakList = mergedPeakList.filterNoisePeaks(this.config.getNoise());
        }
        mergedPeakList = mergedPeakList.sortByMZ();
        PeakList.checkForIntensityCorrectness(peakList, mergedPeakList);
        return mergedPeakList;
    }

    public boolean wasRunning() {
        return this.running;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public String getAnnotatedSpectrum() {
        return this.createAnnotatedSpectrum(this.peakList);
    }

    public List<String> getDotGraphs() {
        if (!this.wasRunning()) {
            throw new IllegalStateException("Deisotope spectrum first");
        }
        ArrayList<String> graph = new ArrayList<String>();
        for (IsotopicSet isotopicSet : this.isotopicSets) {
            graph.add(isotopicSet.getDot());
        }
        return graph;
    }

    public List<IsotopicSet> getIsotopicSets() {
        return this.isotopicSets;
    }

    protected List<IsotopicCluster> getBestClusters() {
        ArrayList<IsotopicCluster> bestClusters = new ArrayList<IsotopicCluster>();
        for (IsotopicSet isotopicSet : this.isotopicSets) {
            bestClusters.addAll(isotopicSet.getBestPath());
        }
        return bestClusters;
    }

    protected PeakList aggregate(List<IsotopicCluster> isotopicClusters, String modus) {
        PeakList resultPeakList = new PeakList();
        double sumBefore = Deisotoper.sumAllIntensities(isotopicClusters);
        isotopicClusters = IsotopicSet.removeOverlappingPeaksInClusters(isotopicClusters);
        for (IsotopicCluster isotopicCluster : isotopicClusters) {
            Peak peak;
            if (isotopicCluster.size() > 1) {
                peak = isotopicCluster.aggregation(modus);
                resultPeakList.add(peak);
                continue;
            }
            if (isotopicCluster.size() == 0) continue;
            peak = isotopicCluster.getPeak(0);
            resultPeakList.add(peak);
        }
        double sumAfter = Deisotoper.sumAllIntensities(isotopicClusters);
        Deisotoper.intensityCheck(sumBefore, sumAfter);
        return resultPeakList;
    }

    protected static List<IsotopicSet> generateIsotopicSets(PeakList peakList, Configuration config) {
        PeakList allPossiblePeaks = Deisotoper.isoSetCollectAllPossiblePeaks(peakList, config);
        allPossiblePeaks = allPossiblePeaks.removeMultiplePeaks();
        allPossiblePeaks = allPossiblePeaks.sortByMZ();
        List<PeakList> allPossiblePeaksParts = Deisotoper.splitIntoParts(allPossiblePeaks, config);
        List<PeakList> listOfIsotopicSets = Deisotoper.iterateThroughParts(allPossiblePeaksParts, config);
        return Deisotoper.addSplittedIsotopicSetsToIsotopicSets(listOfIsotopicSets, peakList, config);
    }

    private String createAnnotatedSpectrum(PeakList peakList) {
        peakList.sortByPeakID();
        return peakList.saveAnnotatedSpectrum();
    }

    private static List<PeakList> iterateThroughParts(List<PeakList> parts, Configuration config) {
        ArrayList<PeakList> combinedPeakLists = new ArrayList<PeakList>();
        for (PeakList part : parts) {
            Set<PeakList> setOfPeakLists = Deisotoper.splitAllPossibleIsotopicSets(new HashSet<Peak>(part.getPeakList()));
            List<PeakList> listOfPeakLists = new ArrayList<PeakList>();
            Deisotoper.sortAndCheckCorrectnessOfSplittedIsotopicSets(setOfPeakLists, listOfPeakLists, config);
            listOfPeakLists = Deisotoper.checkForContainingAndRemoveWrongSets(listOfPeakLists);
            combinedPeakLists.addAll(listOfPeakLists);
        }
        return combinedPeakLists;
    }

    private static List<IsotopicSet> addSplittedIsotopicSetsToIsotopicSets(List<PeakList> listOfIsotopicSets, PeakList peakList, Configuration config) {
        ArrayList<IsotopicSet> isotopicSets = new ArrayList<IsotopicSet>();
        int id = 0;
        for (PeakList isotopicSet : listOfIsotopicSets) {
            IsotopicSet temporaryIsotopicSet = new IsotopicSet(peakList, isotopicSet.getPeakList(), id, config);
            ++id;
            isotopicSets.add(temporaryIsotopicSet);
        }
        return isotopicSets;
    }

    private static List<PeakList> sortAndCheckCorrectnessOfSplittedIsotopicSets(Set<PeakList> allPossiblePeaks, List<PeakList> correctIsotopicSets, Configuration config) {
        for (PeakList possiblePeaks : allPossiblePeaks) {
            if (1 >= possiblePeaks.size()) continue;
            possiblePeaks = possiblePeaks.sortByMZ();
            if ((possiblePeaks = IsotopicSet.checkForCorrectRangeOfPeaks(possiblePeaks, config)) == null) continue;
            correctIsotopicSets.add(possiblePeaks);
        }
        return correctIsotopicSets;
    }

    private static PeakList isoSetCollectAllPossiblePeaks(PeakList peakList, Configuration config) {
        PeakList allPossiblePeaks = new PeakList();
        for (int i = 0; i < peakList.size(); ++i) {
            Peak peakI = peakList.get(i);
            for (int j = 0; j < peakList.size(); ++j) {
                Peak peakJ = peakList.get(j);
                allPossiblePeaks = allPossiblePeaks.collectForEachCharge(peakI, peakJ, config);
            }
        }
        return allPossiblePeaks;
    }

    private static List<PeakList> splitIntoParts(PeakList peaks, Configuration config) {
        ArrayList<PeakList> partsOfPeaks = new ArrayList<PeakList>();
        int j = 0;
        for (int i = 0; i < peaks.size() - 1; ++i) {
            PeakList peaks2;
            double distance = peaks.get(i + 1).getMz() - peaks.get(i).getMz();
            if (distance > config.getIsotopicPeakDistance() + 1.0) {
                peaks2 = new PeakList(peaks.getPeakList().subList(j, i + 1));
                partsOfPeaks.add(peaks2);
                j = i + 1;
                continue;
            }
            if (i != peaks.size() - 2) continue;
            peaks2 = new PeakList(peaks.getPeakList().subList(j, i + 2));
            partsOfPeaks.add(peaks2);
        }
        return partsOfPeaks;
    }

    private static List<PeakList> checkForContainingAndRemoveWrongSets(List<PeakList> listOfPeakLists) {
        List<PeakList> tempListOfPeakLists = new ArrayList<PeakList>(listOfPeakLists);
        for (PeakList peakList1 : listOfPeakLists) {
            for (PeakList peakList2 : listOfPeakLists) {
                if (peakList1.equals(peakList2) || Collections.indexOfSubList(peakList1.getPeakList(), peakList2.getPeakList()) == -1) continue;
                if (peakList1.size() > peakList2.size()) {
                    tempListOfPeakLists.remove(peakList2);
                    continue;
                }
                if (peakList1.size() >= peakList2.size()) continue;
                tempListOfPeakLists.remove(peakList1);
            }
        }
        tempListOfPeakLists = Deisotoper.checkIfRemovedCorrectly(tempListOfPeakLists);
        return tempListOfPeakLists;
    }

    private static List<PeakList> checkIfRemovedCorrectly(List<PeakList> listOfPeakLists) {
        ArrayList<PeakList> tempListOfPeakLists = new ArrayList<PeakList>(listOfPeakLists);
        for (PeakList peaks1 : listOfPeakLists) {
            for (PeakList peaks2 : listOfPeakLists) {
                if (peaks1.size() > peaks2.size() && peaks1.getPeakList().containsAll(peaks2.getPeakList())) {
                    tempListOfPeakLists.remove(peaks2);
                    continue;
                }
                if (peaks1.size() >= peaks2.size() || !peaks2.getPeakList().containsAll(peaks1.getPeakList())) continue;
                tempListOfPeakLists.remove(peaks1);
            }
        }
        return tempListOfPeakLists;
    }

    private static Set<PeakList> splitAllPossibleIsotopicSets(Set<Peak> setOfPeaks) {
        HashSet<PeakList> allPeaks = new HashSet<PeakList>();
        if (setOfPeaks.isEmpty()) {
            allPeaks.add(new PeakList());
            return allPeaks;
        }
        PeakList listOfPeaks = new PeakList();
        listOfPeaks.setPeakList(new ArrayList<Peak>(setOfPeaks));
        Peak head = listOfPeaks.get(0);
        HashSet<Peak> rPeaks = new HashSet<Peak>(listOfPeaks.getPeakList().subList(1, listOfPeaks.size()));
        for (PeakList peaks : Deisotoper.splitAllPossibleIsotopicSets(rPeaks)) {
            PeakList newPeaks = new PeakList();
            newPeaks.add(head);
            newPeaks.addAll(peaks);
            allPeaks.add(newPeaks);
            allPeaks.add(peaks);
        }
        return allPeaks;
    }

    private static void intensityCheck(double before, double after) {
        if (!MathUtils.fuzzyEqual(before, after, 0.001)) {
            // empty if block
        }
    }

    private static double sumAllIntensities(List<IsotopicCluster> isotopicClusters) {
        PeakList peakList = new PeakList();
        double intensitySum = 0.0;
        for (IsotopicCluster isotopicCluster : isotopicClusters) {
            peakList.addAll(isotopicCluster.getIsotopicCluster());
        }
        peakList.removeMultiplePeaks();
        for (Peak peak : peakList.getPeakList()) {
            intensitySum += peak.getIntensity();
        }
        return intensitySum;
    }
}

