/*
 * Decompiled with CFR 0.152.
 */
package ch.fgcz.proteomics.fbdm;

import ch.fgcz.proteomics.fbdm.Configuration;
import ch.fgcz.proteomics.fbdm.Peak;
import ch.fgcz.proteomics.fbdm.PeakList;
import ch.fgcz.proteomics.fbdm.Score;
import ch.fgcz.proteomics.utilities.MathUtils;
import java.util.ArrayList;
import java.util.List;

public class IsotopicCluster {
    private List<Peak> clusterPeaks = new ArrayList<Peak>();
    private int charge;
    private int clusterId;
    private String status;
    private PeakList peakList;
    private double score;

    public IsotopicCluster(List<Peak> isotopicCluster, int charge, PeakList peakList, double isotopicPeakDistance, double delta) {
        IsotopicCluster.rangeCheck(isotopicCluster, charge, isotopicPeakDistance, delta);
        this.clusterPeaks = isotopicCluster;
        this.charge = charge;
        this.peakList = peakList;
    }

    public IsotopicCluster(String status) {
        this.clusterPeaks = null;
        this.charge = 0;
        this.status = status;
    }

    public Peak aggregation(String modus) {
        if (modus.equals("first")) {
            return this.aggregateFirst();
        }
        if (modus.equals("highest")) {
            throw new IllegalArgumentException("Modus: " + modus + " is deprecated");
        }
        throw new IllegalArgumentException("Modus not found (" + modus + ")");
    }

    public double getScore() {
        return this.score;
    }

    public Peak getPeak(int i) {
        return this.clusterPeaks.get(i);
    }

    public int size() {
        return this.clusterPeaks.size();
    }

    public int getClusterID() {
        return this.clusterId;
    }

    public void setClusterID(int clusterId) {
        this.clusterId = clusterId;
    }

    public String getStatus() {
        return this.status;
    }

    public int getCharge() {
        return this.charge;
    }

    public List<Peak> getIsotopicCluster() {
        return this.clusterPeaks;
    }

    public boolean isNotNull() {
        return this.clusterPeaks != null;
    }

    public boolean isNull() {
        return this.clusterPeaks == null;
    }

    public double sumIntensity() {
        double intensitySum = 0.0;
        for (Peak peak : this.clusterPeaks) {
            intensitySum += peak.getIntensity();
        }
        return intensitySum;
    }

    public boolean hasSamePeaks(IsotopicCluster isotopicClusterToCompare) {
        for (Peak peak1 : this.getIsotopicCluster()) {
            for (Peak peak2 : isotopicClusterToCompare.getIsotopicCluster()) {
                if (!peak1.equalsPeak(peak2)) continue;
                return true;
            }
        }
        return false;
    }

    public void manipulateWhenHasSamePeaks(IsotopicCluster isotopicCluster) {
        if (this.getCharge() > isotopicCluster.getCharge()) {
            this.getIsotopicCluster().removeAll(isotopicCluster.getIsotopicCluster());
        } else if (this.getCharge() < isotopicCluster.getCharge()) {
            isotopicCluster.getIsotopicCluster().removeAll(this.getIsotopicCluster());
        } else {
            double intensitySumOfCluster2;
            double intensitySumOfCluster1 = this.sumIntensity();
            if (intensitySumOfCluster1 > (intensitySumOfCluster2 = isotopicCluster.sumIntensity())) {
                isotopicCluster.getIsotopicCluster().removeAll(this.getIsotopicCluster());
            } else {
                this.getIsotopicCluster().removeAll(isotopicCluster.getIsotopicCluster());
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(" + this.clusterId + ") [ ");
        if (this.clusterPeaks == null) {
            return this.status;
        }
        for (Peak p : this.clusterPeaks) {
            stringBuilder.append(p.getMz() + " ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private Peak aggregateFirst() {
        double intensitySum = this.sumIntensity();
        return this.rearrangeCluster(intensitySum);
    }

    private Peak rearrangeCluster(double intensitySum) {
        return new Peak(this.clusterPeaks.get(0).getMz(), intensitySum, this.charge);
    }

    private static void rangeCheck(List<Peak> peaks, int charge, double isotopicDistance, double delta) {
        for (int i = 0; i < peaks.size() - 1; ++i) {
            double theorDistance;
            double distance = peaks.get(i + 1).getMz() - peaks.get(i).getMz();
            if (MathUtils.fuzzyEqual(distance, theorDistance = isotopicDistance / (double)charge, delta)) continue;
            throw new IllegalArgumentException("Wrong distance at IsotopicCluster creation! (" + distance + "while only " + theorDistance + " allowed.)");
        }
    }

    public void scoreCluster(Configuration config) {
        Score sObj = new Score(this.peakList.getPeptideMass(), this.peakList.getChargeState(), config);
        double scoreSum = 0.0;
        if (this.isNotNull()) {
            for (Peak peakX : this.clusterPeaks) {
                for (Peak peakY : this.peakList.getPeakList()) {
                    if (peakX.equalsPeak(peakY)) continue;
                    double scoreResult = sObj.calculateAggregatedScore(peakX.getMz(), peakY.getMz(), this.getIsotopicCluster());
                    scoreSum += scoreResult;
                }
            }
        }
        if (scoreSum == 0.0) {
            scoreSum = (double)(this.clusterPeaks.size() * this.peakList.getPeakList().size()) * 1.0E-6;
        }
        this.score = scoreSum;
    }
}

