% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voronoi.R
\name{plotVoronoi}
\alias{plotVoronoi}
\title{Plot Voronoï diagram}
\usage{
plotVoronoi(
  tessellation,
  colors = "random",
  hue = "random",
  luminosity = "light",
  alpha = 1,
  ...
)
}
\arguments{
\item{tessellation}{an output of \code{\link{Voronoi}}}

\item{colors}{this can be \code{"random"} to use random colors for the cells
(with \code{\link[randomcoloR]{randomColor}}), \code{"distinct"} to use
distinct colors with the help of
\code{\link[randomcoloR]{distinctColorPalette}}, \code{NA} for no colors, 
or this can be a vector of colors; the length of this vector
of colors must match the number of Voronoï cells, that you can get by
typing \code{length(tessellation)}}

\item{hue, luminosity}{if \code{colors = "random"}, these arguments are passed
to \code{\link[randomcoloR]{randomColor}}}

\item{alpha}{opacity, a number between 0 and 1
(used when \code{colors} is not \code{NA})}

\item{...}{arguments passed to \code{\link[graphics]{polygon}} to plot the 
cells}
}
\value{
No returned value.
}
\description{
Plot a Voronoï tessellation.
}
\examples{
library(delaunay)
# make vertices
nsides <- 12L
angles <- seq(0, 2*pi, length.out = nsides+1L)[-1L]
outer_points <- cbind(cos(angles), sin(angles))
inner_points <- outer_points / 4
nsides <- 36L
angles <- seq(0, 2*pi, length.out = nsides+1L)[-1L]
middle_points <- cbind(cos(angles), sin(angles)) / 2
vertices <- rbind(outer_points, inner_points, middle_points)
angles <- angles + pi/36
middle_points <- cbind(cos(angles), sin(angles)) / 3
vertices <- rbind(vertices, middle_points, 2*middle_points)
# constraint edges
indices <- 1L:12L
edges <- cbind(
  indices, c(indices[-1L], indices[1L])
)
edges <- rbind(edges, edges + 12L)
## | constrained Delaunay triangulation 
del <- delaunay(vertices, constraints = edges)
opar <- par(mar = c(0,0,0,0))
plotDelaunay2D(
  del, type = "n", xlab = NA, ylab = NA, axes = FALSE, asp = 1,
  fillcolor = "random", luminosity = "dark", 
  col_borders = "black", lwd_borders = 3
)
par(opar)
## | corresponding Voronoï diagram
vor <- Voronoi(del)
opar <- par(mar = c(0,0,0,0))
plot(
  vertices, type = "n", asp = 1, axes = FALSE, xlab = NA, ylab = NA 
)
plotVoronoi(vor, luminosity = "dark")
points(vertices, pch = 19)
par(opar)
}
