% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_delim.R
\name{check_delim}
\alias{check_delim}
\title{Checks If Two or More Species Delimitation Outputs are (Nearly) Equal}
\usage{
check_delim(list)
}
\arguments{
\item{list}{a \link[base:list]{list} containing two or more species delimitation outputs to check.}
}
\value{
A single logical value, \code{TRUE} or \code{FALSE}.
}
\description{
\code{check_delim()} checks if two or more species delimitation outputs have
differences in its dimensions, labels, and values.
}
\details{
\code{check_delim()} will check if two or more species delimitation outputs have
different dimensions (rows, columns), if labels are the same or if there are
any duplicated or absent labels, and if there are any NA values or if partitions
were set using non numeric values. If \code{TRUE} for any of the cases listed above,
\code{check_delim()} will return an error.
}
\examples{

# create dummy delimitation outputs
delim_1 <- tibble::tibble(
  labels = paste0("seq", 1:10),
  method_A = c(rep(1, 5), rep(2, 5))
)

delim_2 <- tibble::tibble(
  labels = paste0("seq", 1:10),
  method_B = c(rep(1, 3), rep(2, 2), rep(3, 5))
)

delim_3 <- tibble::tibble(
  labels = paste0("seq", 1:10),
  method_C = c(rep(1, 3), rep(2, 2), rep(3, 3), rep(4, 2))
)

# check outputs
check_delim(list(delim_1, delim_2, delim_3))

}
\author{
Pedro S. Bittencourt, Rupert A. Collins.
}
