% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cshp_mult.R
\name{cshp_mult}
\alias{cshp_mult}
\title{Mapping cshapes Multiples}
\usage{
cshp_mult(
  dates,
  cowcodes,
  bb,
  jitter_labs = TRUE,
  highlight = "#00dada",
  lat_grat = round(as.numeric(abs(bb[2] - bb[4])/4)),
  long_grat = round(as.numeric(abs(bb[1] - bb[3])/4)),
  lab_size = 3
)
}
\arguments{
\item{dates}{A vector of dates indicating time-steps of interest. Each
element must be formatted with \code{as.Date(YYYY-M-D)}.}

\item{cowcodes}{A vector, or list, of Correlates of War numeric country codes
to highlight at each corresponding timestep specified in \code{date}. The length
of \code{dates} and \code{cowcodes} must be equal. Multiple countries can be
highlighted at a given timestep by using a list.}

\item{bb}{A bounding box to crop the the global cshapes map. Must be a named
vector of the form \code{c(xmin=long, ymin=lat, xmax=long, ymax=lat)}.}

\item{jitter_labs}{Logical to toggle country label jittering with
\code{ggrepel::geom_text_repel()}.}

\item{highlight}{Hex color value for country highlighting.}

\item{lat_grat}{Numeric value for latitudinal graticule spacing.}

\item{long_grat}{Numeric value for longitudinal graticule spacing.}

\item{lab_size}{Numeric value for country label text size.}
}
\value{
A list of \code{ggplot2} plotting devices. Each element corresponds to an
element of \code{dates}.
}
\description{
Create a sequence of cshapes maps highlighting changes in nation-state
independence.
}
\details{
The \code{chsp_mult} and \code{plot.chsp_mult} functions are currently
experimental functions that are slated for future improvements to the
interface, automated ease of use, and stability. Despite the testing
procedures in place, they may produce odd results with certain combinations
of \code{dates}, countries (\code{cow_codes}), and bounding boxes (\code{bb}).
}
\examples{
\donttest{
if(requireNamespace("cshapes")){
dates = c(
as.Date("1989-1-1"),
as.Date("1992-5-1"),
as.Date("1993-5-1"),
as.Date("2006-7-1"),
as.Date("2008-3-1")
)
cow_codes = list(345,
                 c(344, 346, 349),
                 343,
                 341,
                 347)

bb<-c(xmin=13,ymin=40,xmax=24,ymax=47)

balkans<-cshp_mult(dates = dates, cowcodes = cow_codes, bb = bb,jitter_labs = FALSE)}}
}
