% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-functions.R
\name{multi_sub}
\alias{multi_sub}
\title{Multiple Column Subset}
\usage{
multi_sub(dat, key.dat, vars = names(key.dat))
}
\arguments{
\item{dat}{A \code{data.table} to be subsetted.}

\item{key.dat}{A \code{data.table} containing multiple columns used
to index and subset \code{dat}.}

\item{vars}{Character string of columns in \code{key.dat} to be used for
subsetting.}
}
\value{
A \code{data.frame, data.table} subsetted by \code{key.dat}.
}
\description{
Multiple Column Subset
}
\examples{

\donttest{
cow_index<-demcon::cow_index()
names(cow_index)[1]<-"COWcode"
dat <- demcon::get_vdem()

dat <- demcon::multi_sub(dat, cow_index, vars = c("COWcode", "year"))}

}
