% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cshp_mult.R
\name{plot.cshp_mult}
\alias{plot.cshp_mult}
\title{Plot A cshapes Multiple}
\usage{
\method{plot}{cshp_mult}(x, y, ...)
}
\arguments{
\item{x}{A list of class \code{chsp_mult} with multiple cshapes
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} devices produced by \code{\link[=cshp_mult]{cshp_mult()}}.}

\item{y}{ignored.}

\item{...}{Additional arguments to be passed to the plotting device.}
}
\value{
A single \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} device.
}
\description{
Plot A cshapes Multiple
}
\examples{
\donttest{
if(requireNamespace("cshapes")){
dates = c(
as.Date("1989-1-1"),
as.Date("1992-5-1"),
as.Date("1993-5-1"),
as.Date("2006-7-1"),
as.Date("2008-3-1"))

cow_codes = list(345,
                 c(344, 346, 349),
                 343,
                 341,
                 347)

bb<-c(xmin=13,ymin=40,xmax=24,ymax=47)

balkans<-cshp_mult(dates = dates, cowcodes = cow_codes,
                   bb = bb,jitter_labs = FALSE)

plot(balkans)
}}
}
