% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cce.R
\name{get_cce}
\alias{get_cce}
\title{Retrieve Chronology of Constitutional Events Dataset}
\usage{
get_cce(load = TRUE, del_file = TRUE, write_out = FALSE)
}
\arguments{
\item{load}{Logical to load downloaded data into local environment.}

\item{del_file}{Logical to delete downloaded and unzipped files/directories
after loading into the local environment.}

\item{write_out}{Logical to write the CCE dataset to your local directory as
a \code{.csv} file.}
}
\value{
A data.frame of CCE country-year data.
}
\description{
Downloads the Chronology of Constitutional Events (CCE) Dataset to a
temporary directory from the Comparative Constitutions Project website.
}
\details{
\subsection{The CCE Dataset}{

The Chronology of Constitutional Events (CCE) is a narrowly focused offering
containing annual country-year observations of generalized "constitutional
events". There are 6 unique designations:
\enumerate{
\item New Constitution
\item Amendment
\item Interim Constitution
\item Suspended Constitution
\item Reinstated Constitution
\item Non-Event (years without the above)
}

The limited scope of the CCE lends itself more to timeline visualizations or a
quick reference, but could be helpful when used in conjunction with additional
datasets or in other applications. CCE could also be used to derive
quantitative metrics of constitutional stability similar to those included
with version 2.0 of the Institutions and Elections Project.
\subsection{Variables}{

Version 1.3 of the CCE dataset contains 20,429 observations and 6 variables. The include:

\describe{
\item{cowcode}{The numeric Correlates of War country code.}
\item{country}{The CCE country name.}
\item{year}{Year of observation.}
\item{systid}{CCE identification number for the constitutional system.}
\item{evntid}{CCE identification number for the constitutional event.}
\item{evnttype}{CCE event type; see above.}
}
}

}
}
\examples{

cce<-get_cce(del_file=TRUE, write_out = FALSE)

}
\seealso{
\href{https://comparativeconstitutionsproject.org/download-data/}{The Comparative Constitutions Project}
}
