% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendro.truncate.R
\name{dendro.truncate}
\alias{dendro.truncate}
\title{Truncation of the dendrometer data}
\usage{
dendro.truncate(df, CalYear, DOY)
}
\arguments{
\item{df}{dataframe with the first column named date and time in the format \code{yyyy-mm-dd HH:MM:SS}.}

\item{CalYear}{numerical value or array of two elements for the desired year of calculation.}

\item{DOY}{numerical value or array of two elements representing the day of year. If we provide an array instead of a single value for \code{CalYear} and a single value for \code{DOY}, it truncates data from the \code{DOY} of the first \code{CalYear} to the same \code{DOY} of the second \code{CalYear}.  Conversely, if we provide one value for \code{CalYear} and an array of two elements for \code{DOY} truncates the data form first \code{DOY} to second \code{DOY} within the same \code{CalYear}. Finally, if we provide an array with two values for both \code{DOY} and \code{CalYear}, it truncates data from the first \code{DOY} of the first \code{CalYear} to the second \code{DOY} of second \code{CalYear}.}
}
\value{
A dataframe with the truncated data for the defined periods.
}
\description{
This function is helpful to truncate dendrometer data for a user-defined period.
}
\examples{
library(dendRoAnalyst)
data(nepa)
#Extracting data from doy 20 to 50 in 2017.
trunc1<-dendro.truncate(df=nepa, CalYear=2017, DOY=c(20,50))
head(trunc1,10)

}
