% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/untangle.R
\name{untangle_random_search}
\alias{untangle_random_search}
\title{Untangle - random search}
\usage{
untangle_random_search(dend1, dend2, R = 100L, L = 1,
  leaves_matching_method = c("labels", "order"), ...)
}
\arguments{
\item{dend1}{a tree object (of class dendrogram/hclust/phylo).}

\item{dend2}{a tree object (of class dendrogram/hclust/phylo).}

\item{R}{numeric (default is 100). The number of shuffles to perform.}

\item{L}{the distance norm to use for measuring the distance between the
two trees. It can be any positive number, often one will want to
 use 0, 1, 1.5, 2 (see 'details' for more).
 It is passed to \link{entanglement}.}

\item{leaves_matching_method}{a character scalar passed to \link{entanglement}.
It can be either "order" or "labels" (default). If using "labels",
then we use the labels for matching the leaves order value.
And if "order" then we use the old leaves order value for matching the
leaves order value.

Using "order" is faster, but "labels" is safer. "order" will assume that
the original two trees had their labels and order values MATCHED.

Hence, it is best to make sure that the trees used here have the same labels
and the SAME values matched to these values - and then use "order" (for
fastest results).

If "order" is used, the function first calls \link{match_order_by_labels}
in order to make sure that the two trees have their labels synced with
their leaves order values.}

\item{...}{not used}
}
\value{
A dendlist with two trees with the best entanglement that was found.
}
\description{
Searches for two untangled dendrogram by randomlly shuflling them and each
time checking if their entanglement was improved.
}
\details{
Untangaling two trees is a hard combinatorical problem without a closed
form solution. One way for doing it is to run through a random spectrom
of options and look for the "best" two trees. This is what this function
offers.
}
\examples{
\dontrun{
dend1 <- iris[,-5] \%>\% dist \%>\% hclust("com") \%>\% as.dendrogram
dend2 <- iris[,-5] \%>\% dist \%>\% hclust("sin") \%>\% as.dendrogram
tanglegram(dend1,dend2)

set.seed(65168)
dend12 <- untangle_random_search(dend1, dend2, R = 10)
tanglegram(dend12[[1]],dend12[[2]])
tanglegram(dend12)

entanglement(dend1,dend2, L = 2) # 0.8894
entanglement(dend12[[1]],dend12[[2]], L = 2) # 0.0998



}
}
\seealso{
\link{tanglegram}, \link{match_order_by_labels},
\link{entanglement}.
}

