% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clique_community_names.R
\name{clique_community_names}
\alias{clique_community_names}
\title{Clique Percolation Method (with node names)}
\usage{
clique_community_names(g, k = 3)
}
\arguments{
\item{g}{network object (igraph)}

\item{k}{clique size to be used. The default is set to smallest possible size (3)}
}
\value{
a dataframe with node names and community name. The community is named as CPM_Kk_number_of_community with k replaced by the value of k.
}
\description{
Function to determine communities in a network using clique percolation method (Palla et al., 2005). Communities are created based on cliques. Cliques are subsets of a network that can be considered complete (sub)networks. The size of the cliques to be used to community detection is part of the input of the function.
}
\examples{
hol_sim <- sim_table(hol_rom)
g_hol <- dendro_network(hol_sim)
clique_community_names(g_hol, k = 3)

}
\references{
Palla, G., Derényi, I., Farkas, I., & Vicsek, T. (2005). Uncovering the overlapping community structure of complex networks in nature and society. Nature, 435(7043), 814-818.

Code adapted from source: https://github.com/angelosalatino/CliquePercolationMethod-R/blob/master/clique.community.R
}
\author{
Angelo Salatino

Ronald Visser
}
