% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\name{height}
\alias{height}
\title{Height of tree or vertical object.}
\usage{
height(distance, top, base, type = c("angle", "slope"),
       angleUnit = c("deg", "rad"))
}
\arguments{
\item{distance}{numeric vector of the horizontal distance between object
and the person who measures angle.}

\item{top, base}{numeric vector of top angle and ground angle respectively
(readings from a clinometer).}

\item{type}{the type of \code{top} and \code{base} measures. Either
\code{"angle"} or \code{"slope"}. Default is \code{"slope"}.}

\item{angleUnit}{the unit of \code{top} and \code{base} measures when
\code{type = "angle"}. Either \code{"deg"} for degree or \code{"rad"} for
radian. Default is \code{"deg"}.}
}
\value{
A vector of heights.
}
\description{
Computes the height of tree, pillar, girder, mast or any
vertical object. Allows both slope (in per cent) and angle measures
(in degree or radian) . No matter the relative position of the persons who
measures angle/slope.
}
\examples{
height(10, 80, 17)
height(17, top = -18, base = -113)
height(distance = 18, top = 42, base = -12, type = "angle", angleUnit = "deg")
height(distance = 18:21, top = 42:45, base = -12:-15, type = "angle", angleUnit = "deg")
## Bellow shows warning messages
height(distance = 18:21, top = -42:-45, base = -12:-15, type = "angle", angleUnit = "deg")
}
\author{
Narcisse Yehouenou \email{narcisstar211@gmail.com}
}
