#' Level of Dengue risk around the world
#' @description Country-wise dengue risk levels (Last accessed from the source on 18 January 2023). 
#' @format A tibble with 148 rows and 3 variables:
#' \describe{
#'   \item{country}{factor Name of the country}
#'   \item{level_of_risk`}{factor Dengue risk level. There are three categories: Frequent or continuous, Sporadic or uncertain. “Frequent or continuous” risk means that either frequent outbreaks occur or transmission is ongoing. “Sporadic or uncertain” risk means that the risk varies and is unpredictable and that country-level data is not available.} 
#'   \item{region}{factor Region}
#'    }
#' @source \url{https://www.cdc.gov/dengue/areaswithrisk/around-the-world.html}
#' @examples 
#' head(level_of_risk)
"level_of_risk"