
# 
# GLM response
# 

setClass("GLMresponse",
	representation(formula="formula",
		family="ANY"
	),
	prototype(
		formula=.~.,
		family=gaussian()
	),
	contains="response"
)

setMethod("GLMresponse",
	signature(formula="formula"),
	function(formula,data=NULL,family=gaussian(),pstart=NULL,fixed=NULL,prob=TRUE, ...) {
		call <- match.call()
		mf <- match.call(expand.dots = FALSE)
		m <- match(c("formula", "data"), names(mf), 0)
		mf <- mf[c(1, m)]
		mf$drop.unused.levels <- TRUE
		mf[[1]] <- as.name("model.frame")
		mf <- eval(mf, parent.frame())
		x <- model.matrix(attr(mf, "terms"),mf)
		y <- model.response(mf)
		if(!is.matrix(y)) y <- matrix(y,ncol=1)
		parameters <- list()
		parameters$coefficients <- vector("numeric",length=ncol(x))
		if(family$family=="gaussian") {
			parameters$sd <- 1
		}
		if(family$family=="binomial") {
			# FIX ME
			y <- model.response(mf)
			switch(is(y)[1],
				factor = {
					y <- as.matrix(as.numeric(as.numeric(y)==1))
					#n <- matrix(1,nrow=nrow(y))
				},
				matrix = {
					if(ncol(y) == 2) {
						#n <- as.matrix(rowSums(y))
						#y <- as.matrix(y[,1])
					} else {
						stop("model response not valid for binomial model")
					}
				},
				numeric = {
					if(sum(y %in% c(0,1)) != length(y)) stop("model response not valid for binomial model")
					#n <- matrix(1,nrow=length(y))
					y <- as.matrix(y)
				},
				stop("model response not valid for binomial model")
				# assume 1 success, rest not
				#y <- as.numeric(as.numeric(y)==1)
			)
		}
		if(family$family=="multinomial") {
			y <- model.response(mf)
			if(is.factor(y)) y <- model.matrix(~y-1) else if(is.numeric(y)) y <- model.matrix(~factor(y)-1)
			parameters$coefficients <- matrix(0,ncol=ncol(y),nrow=ncol(x))
			if(is.null(fixed)) {
				fixed <- parameters$coefficients
				fixed[,family$base] <- 1 
				fixed <- c(as.logical(t(fixed)))
			}
		}
		npar <- length(unlist(parameters))
		if(is.null(fixed)) fixed <- as.logical(rep(0,npar))
		if(!is.null(pstart)) {
			if(length(pstart)!=npar) stop("length of 'pstart' must be",npar)
			if(family$family=="multinomial") {
				if(family$link=="identity") parameters$coefficients[1,] <- family$linkfun(pstart[1:ncol(parameters$coefficients)])
				else {
					if(prob) parameters$coefficients[1,] <- family$linkfun(pstart[1:ncol(parameters$coefficients)],base=family$base)
					else parameters$coefficients[1,] <- pstart[1:ncol(parameters$coefficients)]
				}
				pstart <- matrix(pstart,ncol(x),byrow=TRUE)
				if(ncol(x)>1) parameters$coefficients[2:ncol(x),] <- pstart[2:ncol(x),]
			} else {
				parameters$coefficients <- family$linkfun(as.numeric(pstart[1:length(parameters$coefficients)]))
			}
			if(length(unlist(parameters))>length(parameters$coefficients)) {
				if(family$family=="gaussian") parameters$sd <- as.numeric(pstart[(length(parameters$coefficients)+1)])
			}
		}
		mod <- switch(family$family,
			gaussian = new("NORMresponse",formula=formula,family=family,parameters=parameters,fixed=fixed,x=x,y=y,npar=npar),
			binomial = new("BINOMresponse",formula=formula,family=family,parameters=parameters,fixed=fixed,x=x,y=y,npar=npar),
			multinomial = new("MULTINOMresponse",formula=formula,family=family,parameters=parameters,fixed=fixed,x=x,y=y,npar=npar),
			poisson = new("POISSONresponse",formula=formula,family=family,parameters=parameters,fixed=fixed,x=x,y=y,npar=npar),
			Gamma = new("GAMMAresponse",formula=formula,family=family,parameters=parameters,fixed=fixed,x=x,y=y,npar=npar),
			new("GLMresponse",formula=formula,family=family,parameters=parameters,fixed=fixed,x=x,y=y,npar=npar)
		)
		mod
	}
)

setMethod("show","GLMresponse",
	function(object) {
		cat("Model of type ", object@family$family, ", formula: ",sep="")
		print(object@formula)
		cat("Coefficients: \n")
		print(object@parameters$coefficients)
		if(object@family$family=="multinomial") {
			# also print probabilities at covariate values of zero
			cat("Probalities at zero values of the covariates.\n")
			if(!(is.null(dim(object@parameters$coefficients)))) {
				cat(object@family$linkinv(object@parameters$coefficients[1,],base=object@family$base),"\n")
			} else {
				cat(object@family$linkinv(object@parameters$coefficients,base=object@family$base),"\n")
			}
		}
		if(object@family$family=="binomial") {
			# also print probabilities at covariate values of zero
			cat("Probality at zero values of the covariates.","\n")
			cat(object@family$linkinv(object@parameters$coefficients[1]),"\n")
		}
		if(object@family$family=="gaussian") {
			cat("sd ",object@parameters$sd,"\n")
		}	
	}
)

setMethod("setpars","GLMresponse",
	function(object, values, which="pars", prob=FALSE, ...) {
		npar <- npar(object)
		if(length(values)!=npar) stop("length of 'values' must be",npar)
		# determine whether parameters or fixed constraints are being set
		nms <- names(object@parameters$coefficients)
		switch(which,
			"pars"= {
				if(object@family$family=="multinomial") {
					
					object@parameters$coefficients <- matrix(values,ncol(object@x),byrow=TRUE)
					
					if(prob) object@parameters$coefficients[1,] <- object@family$linkfun(values[1:ncol(object@parameters$coefficients)],base=object@family$base)
					
# 					object@parameters$coefficients[1,] <- values[1:ncol(object@parameters$coefficients)]
# 					values <- matrix(values,,ncol(object@x),byrow=TRUE)
# 					if(ncol(object@x)>1) object@parameters$coefficients[2:ncol(object@x),] <- values[2:ncol(object@x),]
				} else {
					object@parameters$coefficients <- values[1:length(object@parameters$coefficients)]
				}
				if(length(unlist(object@parameters))>length(object@parameters$coefficients)) {
					if(object@family$family=="gaussian") object@parameters$sd <- as.numeric(values[(length(object@parameters$coefficients)+1)])
				}
			},
			"fixed" = {
				object@fixed <- as.logical(values)
			}
		)
		names(object@parameters$coefficients) <- nms
		return(object)
	}
)

setMethod("getpars","GLMresponse",
	function(object,which="pars",...) {
		switch(which,
			"pars" = {
				parameters <- numeric()
				if(object@family$family=="multinomial") {
					# coefficient is usually a matrix here 		
					parameters <- c(t(object@parameters$coefficients)) # Why transpose?
				} else {
					parameters <- unlist(object@parameters)
				}
				pars <- parameters
			},
			"fixed" = {
				pars <- object@fixed
			}
		)
		return(pars)
	}
)

# methods: fit, logDens, predict
# use: in EM (M step)
# returns: (fitted) response with (new) estimates of parameters

setMethod("fit","GLMresponse",
	function(object,w) {
    if(missing(w)) w <- NULL
		pars <- object@parameters
		fit <- glm.fit(x=object@x,y=object@y,weights=w,family=object@family,start=pars$coefficients)
		pars$coefficients <- fit$coefficients
		object <- setpars(object,unlist(pars))
		object
	}
)

setMethod("logLik","GLMresponse",
	function(object) {
		sum(logDens(object))
	}
)

setMethod("predict","GLMresponse",
	function(object) {
		object@family$linkinv(object@x%*%object@parameters$coefficients)
	}
)