% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.r
\name{combine}
\alias{combine}
\title{combine}
\usage{
combine(x1, x2)
}
\arguments{
\item{x1, x2}{Two different deques, stacks, or queues. Arguments must be of the same type.}
}
\value{
Returns \code{NULL}. After combining, object \code{x2} is a 0-length (empty)
object.
}
\description{
Combine two objects (queue/stack/deque) into one of the same type.
}
\details{
Operates via side-effects; see examples for clarification on usage.
}
\examples{
\dontrun{
library(dequer)
s1 <- stack()
for (i in 1:5) push(s1, i)
s2 <- stack()
for (i in 10:8) push(s2, i)

combine(s1, s2)
s1 # now holds all 8 elements
s2 # holds 0 elements
}

}

