% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best_degree.R
\name{best_degree}
\alias{best_degree}
\title{Find the best polynomial degree for polynomial detrending.}
\usage{
best_degree(img, seed = NULL, parallel = FALSE)
}
\arguments{
\item{img}{A 3-dimensional array of integers representing the image series.
\code{img[i, j, k]} is the pixel at \code{x = i}, \code{y = j} in frame \code{k} of the image
series.}

\item{seed}{A seed for the random number generation needed in this function.
If you do not set a seed, one will be chosen randomly.}

\item{parallel}{Do you want this function to run on multiple cores? If not,
use \code{parallel = FALSE} (the default). To use \code{n} cores, use \code{parallel = n}
or to use all available cores use \code{parallel = TRUE}.}
}
\value{
If no detrend is necessary, this function returns \code{NA}. If a detrend
is required, this function returns a natural number which is the ideal
polynomial degree for polynomial detrending.
}
\description{
Use Nolan's algorithm to find the ideal polynomial degree for polynomial
detrending.
}
\examples{
\dontrun{
## These examples are not run on CRAN because they take too long.
## You should still try them for yourself.
img <- read_tif(system.file('extdata', 'bleached.tif', package = 'detrendr'),
                n_ch = 1)
best_degree(img, seed = 0, parallel = 2)
}
}
\references{
Rory Nolan, Luis A. J. Alvarez, Jonathan Elegheert, Maro
Iliopoulou, G. Maria Jakobsdottir, Marina Rodriguez-Muñoz, A. Radu
Aricescu, Sergi Padilla-Parra; nandb—number and brightness in R with a
novel automatic detrending algorithm, Bioinformatics,
https://doi.org/10.1093/bioinformatics/btx434.
}
