% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_constructors.R
\name{detrended_img}
\alias{detrended_img}
\title{Detrended image class.}
\usage{
detrended_img(img, method, parameter, auto, purpose = c("FCS", "FFS"))
}
\arguments{
\item{img}{The detrended image series. A 4-dimensional array of non-negative
integers in the style of an \link[ijtiff:ijtiff_img]{ijtiff_img}, or a
3-dimensional array of non-negative integers which represents a single
channel of an \link[ijtiff:ijtiff_img]{ijtiff_img}-style array (indexed by
\code{img[y, x, frame]}).}

\item{method}{The method used. One of \code{"boxcar"}, \code{"exponential"} or
\code{"polynomial"}.}

\item{parameter}{A number. The detrend parameter used. One per channel.}

\item{auto}{Logical. Was automatic detrending used? One per channel.}

\item{purpose}{Was the image detrended for the purpose of doing FCS or FFS
calculations? See \link{detrending}.}
}
\value{
An object of class \code{detrended_img}.
}
\description{
A \link{detrended_img} is a 4-dimensional array of positive integers in the style
of an \link[ijtiff:ijtiff_img]{ijtiff_img} (indexed by \code{img[y, x, channel, frame]}) which is the result of a detrending routine. It has 4 attributes:
\describe{\item{\code{method}}{The detrending method used. This must be one of
\code{"boxcar"}, \code{"exponential"} or \code{"polynomial"}. } \item{\code{parameter}}{The value
of the parameter used. This will be the \code{l}, \code{tau} or \code{degree} parameter for
the respective methods.} \item{\code{auto}}{A boolean that is \code{TRUE} if the
parameter was found automatically or \code{FALSE} if it was manually selected. }
\item{\code{purpose}}{Either "FCS" or "FFS" to denote whether the detrending was
done for the purpose of fluorescence correlation spectroscopy or fluorescence
fluctuation spectroscopy calculations respectively.}}
}
\details{
Sometimes when detrending, you can get slight negative values in the
detrended image. These values should really just be zero, so this constructor
function sets negative values of \code{img} to zero.
}
