% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{damos_11}
\alias{damos_11}
\title{Inverse second-order polynomial equation of development rate as a function of temperature.}
\format{
A list of eight elements describing the equation.
\describe{
  \item{eq}{The equation (formula object).}
  \item{eqAlt}{The equation (string).}
  \item{name}{The name of the equation.}
  \item{ref}{The equation reference.}
  \item{refShort}{The equation reference shortened.}
  \item{startVal}{The parameters found in the literature with their references.}
  \item{com}{An optional comment about the equation use.}
  \item{id}{An id to identify the equation.}
}
}
\source{
\url{http://dx.doi.org/10.1155/2012/123405}
}
\usage{
damos_11
}
\description{
Damos, P., and Savopoulou-Soultani, M. (2011) Temperature-driven models for insect
development and vital thermal requirements. Psyche: A Journal of Entomology, 2012.
}
\details{
Equation:
\deqn{rT = \frac{aa}{1 + bb * T + cc * T^{2}}}{%
      rT = aa / (1 + bb * T + cc * T^2)}

where rT is the development rate, T the temperature, and aa, bb, and
cc empirical constant parameters.
}
\keyword{datasets}
