% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{janisch_32}
\alias{janisch_32}
\title{Janisch equation of development rate as a function of temperature (Analytis modification).}
\format{
A list of eight elements describing the equation.
\describe{
  \item{eq}{The equation (formula object).}
  \item{eqAlt}{The equation (string).}
  \item{name}{The name of the equation.}
  \item{ref}{The equation reference.}
  \item{refShort}{The equation reference shortened.}
  \item{startVal}{The parameters found in the literature with their references.}
  \item{com}{An optional comment about the equation use.}
  \item{id}{An id to identify the equation.}
}
}
\source{
\url{http://dx.doi.org/10.1111/j.1365-2311.1932.tb03305.x}
}
\usage{
janisch_32
}
\description{
Janisch, E. (1932) The influence of temperature on the life-history of insects.
Transactions of the Royal Entomological Society of London 80(2): 137-68.

Analytis, S. (1977) Uber die Relation zwischen biologischer Entwicklung und
Temperatur bei phytopathogenen Pilzen. Journal of Phytopathology 90(1): 64-76.

Analytis, S. (1981). Relationship between temperature and development
times in phytopathogenic fungus and in plant pests: a mathematical model. Agric.
Res.(Athens), 5, 133-159.

Kontodimas, D.C., Eliopoulos, P.A., Stathas, G.J. and Economou, L.P. (2004) Comparative
temperature-dependent development of Nephus includens (Kirsch) and Nephus bisignatus
(Boheman)(Coleoptera: Coccinellidae) preying on Planococcus citri
(Risso)(Homoptera: Pseudococcidae): evaluation of a linear and various nonlinear models
using specific criteria. Environmental Entomology 33(1): 1-11.
}
\details{
Equation:
\deqn{rT = (\frac{Dmin}{2} * (e^{aa*(T - Topt)} + e^{-bb*(T - Topt)}))^{-1}}{%
      rT = (Dmin/2 * (exp(aa*(T - Topt)) + exp(-bb*(T - Topt))))^(-1)}

where rT is the development rate, T the temperature, Topt the optimum temperature,
Dmin, aa, and bb constants.
}
\keyword{datasets}
