% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{wagner_88}
\alias{wagner_88}
\title{Hagstrum et Milliken equation of development rate as a function of temperature retrieved
from Wagner 1984.}
\format{
A list of eight elements describing the equation.
\describe{
  \item{eq}{The equation (formula object).}
  \item{eqAlt}{The equation (string).}
  \item{name}{The name of the equation.}
  \item{ref}{The equation reference.}
  \item{refShort}{The equation reference shortened.}
  \item{startVal}{The parameters found in the literature with their references.}
  \item{com}{An optional comment about the equation use.}
  \item{id}{An id to identify the equation.}
}
}
\source{
\url{https://doi.org/10.1093/aesa/77.2.208}

\url{http://dx.doi.org/10.1093/aesa/81.4.539}
}
\usage{
wagner_88
}
\description{
Hagstrum, D.W., Milliken, G.A. (1988) Quantitative analysis of temperature, moisture, and
diet factors affecting insect development. Annals of the Entomological Society of America
81(4): 539-46.

Wagner, T.L., Wu, H.I., Sharpe, P.S.H., Schoolfield, R.M., Coulson, R.N. (1984) Modeling
insect development rates: a literature review and application of a biophysical model.
Annals of the Entomological Society of America 77(2): 208-20.
}
\details{
Equation:
\deqn{rT = \frac{1}{\frac{1 + e^{\frac{cc}{1.987} * (\frac{1}{dd} - \frac{1}{T + 273.16})}}{aa*\frac{T + 273.16}{298.15}*e^{\frac{bb}{1.987}*(\frac{1}{298.15} - \frac{1}{T + 273.16})}}}}{%
      rT = 1/( (1 + exp((cc/1.987) * ((1/dd) - (1/(T + 273.16))) )) / (aa * (T + 273.16)/298.15 * exp( (bb/1.987) * ((1/298.15) - 1/(T + 273.16)) ) ) )}

where rT is the development rate, T the temperature, and aa, bb, cc,
and dd are thermodynamic parameters.
}
\keyword{datasets}
