% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gh_issues.R
\name{get_gh_issues}
\alias{get_gh_issues}
\title{Get issues information from GitHub for the given time period.}
\usage{
get_gh_issues(owner, repo, start_date = NULL, end_date = NULL)
}
\arguments{
\item{owner}{String specifying the owner of the repository.}

\item{repo}{String specifying the name of the repo.}

\item{start_date}{String specifying start date of reporting period to filter
by, in the format \code{YYYY-MM-DD}. \code{NULL} by default, where no filters will be
applied.}

\item{end_date}{String specifying end date of reporting period to filter by,
in the format \code{YYYY-MM-DD}. \code{NULL} by default, where no filters will be
applied.}
}
\value{
A data frame containing details of GitHub issues identified in the
specified date range.
}
\description{
Get information on issues from the specified GitHub
repository. This is a wrapper around the 'gh' package. Original code taken
from \url{https://github.com/jennybc/analyze-github-stuff-with-r/}.
}
\examples{
\donttest{
get_gh_issues(owner = "martinctc", repo = "rwa")
}

}
