% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install-git.r
\name{install_git}
\alias{install_git}
\title{Install a package from a git repository}
\usage{
install_git(url, subdir = NULL, branch = NULL, credentials = NULL,
  args = character(0), ...)
}
\arguments{
\item{url}{Location of package. The url should point to a public or
private repository.}

\item{subdir}{A sub-directory within a git repository that may
contain the package we are interested in installing.}

\item{branch}{Name of branch or tag to use, if not master.}

\item{credentials}{A git2r credentials object passed through
to \code{\link[git2r]{clone}}.}

\item{args}{DEPRECATED. A character vector providing extra arguments to
pass on to git.}

\item{...}{passed on to \code{\link{install}}}
}
\description{
It is vectorised so you can install multiple packages with
a single command. You do not need to have git installed.
}
\examples{
\dontrun{
install_git("git://github.com/hadley/stringr.git")
install_git("git://github.com/hadley/stringr.git", branch = "stringr-0.2")
}
}
\seealso{
Other package installation: \code{\link{install_bioc}},
  \code{\link{install_bitbucket}},
  \code{\link{install_cran}}, \code{\link{install_github}},
  \code{\link{install_svn}}, \code{\link{install_url}},
  \code{\link{install_version}}, \code{\link{install}},
  \code{\link{uninstall}}
}

