% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dexter.R
\name{plausible_values}
\alias{plausible_values}
\title{Draw plausible values}
\usage{
plausible_values(dataSrc, parms, predicate = NULL, nPV = 1,
  use_draw = NULL)
}
\arguments{
\item{dataSrc}{Data source: a dexter project db handle or a data.frame}

\item{parms}{An object returned by function \code{fit_enorm} and containing
parameter estimates}

\item{predicate}{an expression to filter data. If missing, the function will use 
all data in dataSrc}

\item{nPV}{Number of plausible values to draw per person.}

\item{use_draw}{When the ENORM was fitted with a Gibbs sampler (this is 
recognised automatically), the number of the random draw (iteration) to use 
in generating the PV. If NULL, all draws will be averaged. If outside range,
the last iteration will be used.}
}
\value{
Depends on the estimation method
}
\description{
Draws plausible values based on sum scores and a fitted
ENORM model
}
\examples{
\dontrun{
db = start_new_project(verbAggrRules, "verbAggression.db", 
   covariates=list(gender="<unknown>"))
add_booklet(db, verbAggrData, "agg")
add_item_properties(db, verbAggrProperties)
f=fit_enorm(db)
par(mfrow=c(1,2))
pv_M=plausible_values(db,f,(mode=="Do")&(gender=="Male"))
pv_F=plausible_values(db,f,(mode=="Do")&(gender=="Female"))
plot(ecdf(pv_M$PV), 
   main="Do: males versus females", xlab="Ability", col="red")
lines(ecdf(pv_F$PV), col="green")
legend(-2.2,0.9, c("female", "male") , 
   lty=1, col=c('green', 'red'), bty='n', cex=.75)

pv_M=plausible_values(db,f,(mode=="Want")&(gender=="Male"))
pv_F=plausible_values(db,f,(mode=="Want")&(gender=="Female"))

plot(ecdf(pv_M$PV), 
   main="Want: males versus females", xlab=" Ability", col="red")
lines(ecdf(pv_F$PV),col="green")
legend(-2.2,0.9, c("female", "male") , 
   lty=1, col=c('green', 'red'), bty='n', cex=.75)
}

}
