% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dexter.R
\name{touch_rules}
\alias{touch_rules}
\title{Add or modify scoring rules}
\usage{
touch_rules(db, rules)
}
\arguments{
\item{db}{handle to a Dexter project database}

\item{rules}{A data frame with columns \code{item_id}, \code{response}, and \code{item_score}.
The order is not important but spelling is. Any other columns will be ignored. See details}
}
\value{
If the scoring rules pass a sanity check, a small summary of changes.
Otherwise, nothing.
}
\description{
Having to alter or add a scoring rule is occasionally necessary, e.g. in case of a key error. 
This function offers the possibility to do so and also allows you to add new items to your project
}
\details{
The rules should contain all rules that you want to change or add. This means that in case of a key error
in a single multiple choice question, you typically have to change two rules.
}
\examples{
\dontrun{
# given that in your dexter project there is an mc item with id 'itm_01', 
# which currently has key 'A' but you want to change it to 'C'.

new_rules = data.frame(item_id='itm_01', response=c('A','C'), item_score=c(0,1))
touch_rules(db, new_rules)
}

}
