% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dexter.R
\name{design_as_network}
\alias{design_as_network}
\title{Test design as network}
\usage{
design_as_network(dataSrc, predicate = NULL, weights = c("items",
  "responses"))
}
\arguments{
\item{dataSrc}{Data source: a dexter project db handle or a data.frame with columns: person_id, item_id, item_score}

\item{predicate}{An optional expression to subset data, if NULL all data is used}

\item{weights}{Weight the edges between booklets by the number of common 
\code{"items"} or \code{"responses"} (default is items).}
}
\value{
A list of two data frames: \item{im}{incidence matrix}
\item{wm}{weights matrix}
\item{ibl}{incidence matrix of items in blocks}
\item{blb}{incidence matrix of blocks in booklets}
}
\description{
Export the test design as an incidence matrix 
and a weight matrix
}
\details{
The output of this function can be passed to packages for network analysis
such as \code{igraph} or \code{qgraph}. We prefer to not load these 
packages automatically as they are fairly large and rely on a number 
of dependencies.
}
\examples{
\donttest{
\dontrun{
dsgn = design_as_network(db)
# Check if design is connected

design_is_connected(dsgn)
}}

}
