% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction_model.R
\name{fit_inter}
\alias{fit_inter}
\title{Estimate the Interaction and the Rasch model}
\usage{
fit_inter(dataSrc, predicate = NULL)
}
\arguments{
\item{dataSrc}{Data source: a dexter project db handle or a data.frame with columns: person_id, item_id, item_score}

\item{predicate}{An optional expression to subset data, if NULL all data is used}
}
\value{
An object of class \code{rim} holding results
for the Rasch model and the interaction model.
}
\description{
Estimate the parameters of the Interaction model and the Rasch model
}
\details{
Unlike the Rasch model, the interaction model cannot be computed
concurrently for a whole design of test forms. This function fits the
Rasch model and the interaction model on a complete rectangular array of
responses. This typically consist of responses to items in one booklet but can also consist of
the intersection (common items) of two or more booklets. If the intersection is empty
(no common items for all persons), the function will exit with an error message.
}
\examples{
\dontrun{
db = start_new_project(verbAggrRules, "verbAggression.db")
add_booklet(db, verbAggrData, "agg")

m = fit_inter(db, booklet_id=='agg')
plot(m, "S1DoScold", show.observed=TRUE)

close_project(db)
}


}
\seealso{
\code{\link{plot.rim}}, \code{\link{fit_domains}}
}
