% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ability.R
\name{ability}
\alias{ability}
\alias{ability_tables}
\title{Estimate abilities}
\usage{
ability(dataSrc, parms, predicate = NULL, method = c("MLE", "EAP"),
  prior = c("normal", "Jeffreys"), use_draw = NULL, npv = 500,
  mu = 0, sigma = 4, standard_errors = FALSE, asOPLM = TRUE)

ability_tables(parms, design = NULL, method = c("MLE", "EAP"),
  prior = c("normal", "Jeffreys"), use_draw = NULL, npv = 500,
  mu = 0, sigma = 4, standard_errors = TRUE, asOPLM = TRUE)
}
\arguments{
\item{dataSrc}{Data source: a dexter project db handle or a data.frame with columns: person_id, item_id, item_score}

\item{parms}{An object returned by \code{\link{fit_enorm}} and containing
parameter estimates}

\item{predicate}{An optional expression to subset data, if NULL all data is used}

\item{method}{Maximum Likelihood (MLE) or Expected A posteriori (EAP)}

\item{prior}{If an EAP estimate is produced one can choose a normal prior or
Jeffreys prior; i.e., a prior proportional to the square root of test information.}

\item{use_draw}{When parms is Bayesian, use_draw is 
the index of the posterior sample of the item 
parameters that will be used for generating plausible values. 
If use_draw=NULL, a posterior mean is used. 
If outside range, the last iteration will be used.}

\item{npv}{Number of plausible values sampled to calculate EAP with normal prior}

\item{mu}{Mean of the normal prior}

\item{sigma}{Standard deviation of the normal prior}

\item{standard_errors}{If true standard-errors are produced.}

\item{asOPLM}{Report abilities on a scale defined by the OPLM normalization. Only when no values in parms have been fixed}

\item{design}{A data.frame with columns item_id and optionally booklet_id. If design is NULL
the score transformation table will be computed based on the test design 
that was used to calibrate the items. If the column booklet_id is not included, the score 
transformation table will be based on all items found in the design.}
}
\value{
\describe{
  \item{ability}{a data.frame with columns: booklet_id, person_id, sumScore, theta and optionally se (standard error) }
  \item{ability_tables}{a data.frame with columns: booklet_id, sumScore, theta and optionally se (standard error)}
}
}
\description{
Computes estimates of ability for persons or booklets
}
\details{
MLE estimates of ability will produce an NA for
the minimum (=0) or the maximum score on a booklet. If this is undesirable, 
we advise to use EAP with Jeffreys prior.
}
\examples{
\dontrun{
db = start_new_project(verbAggrRules, "verbAggression.db")
add_booklet(db, verbAggrData, "agg")
f = fit_enorm(db)
aa = ability_tables(f,method="MLE",standard_errors=FALSE)
bb = ability_tables(f,method="EAP",standard_errors=FALSE)
cc = ability_tables(f,method="EAP",prior="Jeffreys", standard_errors=FALSE)
plot(bb$sumScore, bb$theta, xlab="test-score", ylab="ability est.", pch=19, cex=0.7)
points(aa$sumScore, aa$theta, col="red", pch=19, cex=0.7)
points(aa$sumScore, cc$theta, col="green", pch=19, cex=0.7)
legend("topleft", legend = c("EAP normal prior", "EAP Jeffreys prior", "MLE"), bty = "n",
        lwd = 1, cex = 0.7, col = c("black", "green", "red"), lty=c(0,0,0), pch = c(19,19,19))

close_project(db)
}


}
