% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ability.R
\name{ability}
\alias{ability}
\alias{ability_tables}
\title{Estimate abilities}
\usage{
ability(
  dataSrc,
  parms,
  predicate = NULL,
  method = c("MLE", "EAP", "WLE"),
  prior = c("normal", "Jeffreys"),
  parms_draw = "average",
  mu = 0,
  sigma = 4,
  merge_within_persons = FALSE
)

ability_tables(
  parms,
  design = NULL,
  method = c("MLE", "EAP", "WLE"),
  prior = c("normal", "Jeffreys"),
  parms_draw = "average",
  mu = 0,
  sigma = 4
)
}
\arguments{
\item{dataSrc}{a connection to a dexter database, a matrix, or a data.frame with columns: person_id, item_id, item_score}

\item{parms}{object produced by \code{\link{fit_enorm}} or a data.frame with columns item_id, item_score and, 
depending on parametrization, a column named either beta/delta, eta or b}

\item{predicate}{An optional expression to subset data, if NULL all data is used}

\item{method}{Maximum Likelihood (MLE), Expected A posteriori (EAP) or Weighted Likelihood (WLE)}

\item{prior}{If an EAP estimate is produced one can choose a normal prior or
Jeffreys prior; i.e., a prior proportional to the square root of test information.}

\item{parms_draw}{When parms is Bayesian, parms_draw can be the index of the posterior sample of the item 
parameters that will be used for generating abilities. If parms_draw='average', the posterior mean is used.}

\item{mu}{Mean of the normal prior}

\item{sigma}{Standard deviation of the normal prior}

\item{merge_within_persons}{for persons who were administered multiple booklets, 
whether to provide just one ability value (TRUE) or one per booklet(FALSE)}

\item{design}{A data.frame with columns item_id and optionally booklet_id. If the column booklet_id is not included, the score 
transformation table will be based on all items found in the design. If design is NULL
and parms is an enorm fit object the score transformation table will be computed based on the test design 
that was used to fit the items.}
}
\value{
\describe{
  \item{ability}{a data.frame with columns: booklet_id, person_id, booklet_score, theta and optionally se (standard error) }
  \item{ability_tables}{a data.frame with columns: booklet_id, booklet_score, theta and optionally se (standard error)}
}
}
\description{
Computes estimates of ability for persons or for booklet scores
}
\details{
MLE estimates of ability will produce -Inf and Inf estimates for
the minimum (=0) and the maximum score on a booklet. If this is undesirable, 
we advise to use WLE. The WLE was proposed by Warm (1989) to reduce bias in the MLE and is also known
as the Warm estimator.
}
\examples{

\dontshow{ RcppArmadillo::armadillo_throttle_cores(1)}

db = start_new_project(verbAggrRules, ":memory:")
add_booklet(db, verbAggrData, "agg")

f = fit_enorm(db)

mle = ability_tables(f, method="MLE")
eap = ability_tables(f, method="EAP", mu=0, sigma=1)
wle = ability_tables(f, method="WLE")

plot(wle$booklet_score, wle$theta, xlab="test-score", ylab="ability est.", pch=19)
points(mle$booklet_score, mle$theta, col="red", pch=19,)
points(eap$booklet_score, eap$theta, col="blue", pch=19)
legend("topleft", legend = c("WLE", "MLE", "EAP N(0,1)"), 
        col = c("black", "red", "blue"), bty = "n",pch = 19)

close_project(db)

\dontshow{ RcppArmadillo::armadillo_reset_cores()}

}
\references{
Warm, T. A. (1989). Weighted likelihood estimation of ability in item response theory. 
Psychometrika, 54(3), 427-450.
}
